/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.cmd;

import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.cmd.FieldProcessor;
import java.sql.SQLException;

public class BooleanFlag
implements FieldProcessor {
    private static final String[] VALID_TRUE_VALUES = new String[]{"TRUE", "1", "T", "YES", "Y", "ON"};
    private static final String[] VALID_FALSE_VALUES = new String[]{"FALSE", "0", "F", "NO", "N", "OFF"};

    private boolean isTrueValue(String fieldValue) {
        if (fieldValue != null && fieldValue.trim().length() > 0) {
            String uppercaseValue = fieldValue.toUpperCase();
            for (String validTrueValue : VALID_TRUE_VALUES) {
                if (!uppercaseValue.equals(validTrueValue)) continue;
                return true;
            }
        }
        return false;
    }

    protected String formatValueFromBoolean(boolean flagValue, WizardInteractorData data, JobProperties props) throws SQLException, ConnectionNotFoundException {
        return flagValue ? "true" : "false";
    }

    @Override
    public final String processFieldData(WizardInteractorData data, String fieldValue, JobProperties props) throws Exception {
        return this.formatValueFromBoolean(this.isTrueValue(fieldValue), data, props);
    }

    @Override
    public boolean validateValue(String fieldValue) {
        String uppercaseString = fieldValue.toUpperCase();
        if (uppercaseString.isEmpty()) {
            return true;
        }
        for (String val : VALID_FALSE_VALUES) {
            if (!val.equals(uppercaseString)) continue;
            return true;
        }
        for (String val : VALID_TRUE_VALUES) {
            if (!val.equals(uppercaseString)) continue;
            return true;
        }
        return false;
    }
}

