/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.tools.dbmt.actions.TypeDef;

public class ValueDef {
    private TypeDef m_typeDef;
    private final String m_fieldLocation;
    private final String m_fieldPrefix;
    private final String m_fieldId;
    private final String m_defaultValue;

    public ValueDef(String fieldLocation, String fieldPrefix, String fieldId, TypeDef typeDef) {
        this(fieldLocation, fieldPrefix, fieldId, typeDef, null);
    }

    public ValueDef(String fieldLocation, String fieldPrefix, String fieldId, TypeDef typeDef, String defaultValue) {
        this.m_typeDef = typeDef;
        this.m_fieldLocation = fieldLocation;
        this.m_fieldPrefix = fieldPrefix;
        this.m_fieldId = fieldId;
        this.m_defaultValue = defaultValue;
    }

    public ValueDef remapToId(String id, String defaultValue) {
        return new ValueDef(this.m_fieldLocation, this.m_fieldPrefix, id, this.m_typeDef, defaultValue);
    }

    public ValueDef remapToId(String id) {
        return this.remapToId(id, this.m_defaultValue);
    }

    public ValueDef remapToProperty(String propRoot) {
        return new ValueDef(propRoot, this.m_fieldPrefix, this.m_fieldId, this.m_typeDef, this.m_defaultValue);
    }

    public final boolean required() {
        return this.m_defaultValue == null;
    }

    public final String getDescKey() {
        return this.m_fieldLocation + "." + this.m_fieldPrefix + "." + this.m_fieldId + ".desc";
    }

    public final String getNameKey() {
        return this.m_fieldLocation + "." + this.m_fieldPrefix + "." + this.m_fieldId + ".name";
    }

    public final TypeDef getTypeDef() {
        return this.m_typeDef;
    }

    public final String getDefaultValue() {
        return this.m_defaultValue;
    }

    public final String getMnemonicKey() {
        return this.m_fieldLocation + "." + this.m_fieldPrefix + "." + this.m_fieldId + ".mnemonic";
    }
}

