/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.SchemaType;
import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InstallSuiteOptionKeys;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.PageInitializerHelper;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardRunner;

public class SetUpgradeWithExistingPxrptUser
implements TransitionMap.TransitionOperation {
    private static final String PXRPTUSER_EXISTS = "pxrptuser_exists";

    @Override
    public String process(WizardRunner runner, WizardInteractorData data, String page, JobProperties jobProps) throws InteractorDataError, ValueNotFound, ConnectionNotFoundException, DBMTException {
        boolean value = jobProps.getJobProperty(InstallSuiteOptionKeys.PM_PRODUCT_KEY) == SchemaType.PM;
        boolean versionAlreadyHasPxrptUser = PageInitializerHelper.hasPxrptuser(jobProps, data);
        data.getPageData(page).setValue(PXRPTUSER_EXISTS, Boolean.toString(value && versionAlreadyHasPxrptUser));
        return null;
    }

    @Override
    public void unProcess(WizardRunner runner, JobProperties properties) throws InteractorDataError {
    }
}

