/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.actions.EnumDataEntry;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.PageInitializerHelper;
import com.primavera.database.tools.dbmt.actions.SelectTypeDef;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.dbservers.mssql.SqlServerLogic;
import com.primavera.database.tools.dbmt.dbservers.oracle.OracleLogic;
import java.sql.SQLException;
import java.util.List;

public class SetPxrptuserSelectOptions
implements TransitionMap.PageInitializer {
    @Override
    public String initializePage(JobProperties jobProps, WizardInteractorData data, String page) throws Exception {
        String fieldId = "pxrptusername";
        String connectionSting = jobProps.getConnection(ConnectionClass.ADMINISTRATIVE);
        boolean isOracle = PageInitializerHelper.isOracle(jobProps, data);
        List<String> usersList = this.getUserList(connectionSting, isOracle);
        SelectTypeDef typeDef = (SelectTypeDef)data.getPageData(page).getDef().getTypeDef(fieldId);
        typeDef.reset();
        for (String username : usersList) {
            typeDef.addValue(new EnumDataEntry(username, username, username, ""));
        }
        if (typeDef.getValues().size() > 0) {
            data.getPageData(page).setValue(fieldId, typeDef.getValues().get(0).getId());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getUserList(String connectionSting, boolean isOracle) throws SQLException {
        DatabaseConnection connection = null;
        try {
            connection = new DatabaseConnection(connectionSting);
            if (isOracle) {
                OracleLogic ol = new OracleLogic();
                List<String> list = ol.getSortedPossiblePxrptusers(connection);
                return list;
            }
            SqlServerLogic ol = new SqlServerLogic();
            List<String> list = ol.getSortedPossiblePxrptusers(connection);
            return list;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    DBMTLogger.warn(Channel.USER, e.getLocalizedMessage());
                }
            }
        }
    }
}

