/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.ProductSuiteType;
import com.primavera.database.common.SchemaInfo;
import com.primavera.database.common.SchemaType;
import com.primavera.database.common.ServerType;
import com.primavera.database.common.connection.ConnectionUtil;
import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.ApplicationContextLogic;
import com.primavera.database.tools.dbmt.JobPropertyNotFound;
import com.primavera.database.tools.dbmt.ProductInfo;
import com.primavera.database.tools.dbmt.actions.InstallSuiteOptionKeys;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.SetPMPPMSchemaInfoListTransOp;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.dbservers.SchemaTypeNotFoundError;
import com.primavera.database.tools.dbmt.dbservers.mssql.SqlServerLogic;
import com.primavera.database.tools.dbmt.dbservers.oracle.OracleLogic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SetPMPPMUpgradeSchemaInfoListTransOp
extends SetPMPPMSchemaInfoListTransOp {
    private ServerType m_serverType;

    public SetPMPPMUpgradeSchemaInfoListTransOp(ApplicationContextLogic contextLogic, ServerType serverType, Map<String, String> valueMap) {
        super(contextLogic, valueMap);
        this.m_serverType = serverType;
    }

    public SetPMPPMUpgradeSchemaInfoListTransOp(ApplicationContextLogic contextLogic, ServerType serverType) {
        this(contextLogic, serverType, new HashMap<String, String>());
    }

    @Override
    protected String getPmProduct(WizardInteractorData data, JobProperties jobProperties) throws InteractorDataError, Exception {
        PmProductTypeOp op = new PmProductTypeOp();
        ConnectionUtil.doConnectionOperation(jobProperties.getConnection(ConnectionClass.ADMINISTRATIVE), op);
        return op.getSchemaType().toString();
    }

    @Override
    protected List<SchemaInfo> getSchemaTypes(WizardInteractorData data, JobProperties jobProps, String product) throws InteractorDataError, SetPMPPMSchemaInfoListTransOp.InvalidSelection, JobPropertyNotFound {
        ProductSuiteType suiteType = (ProductSuiteType)((Object)jobProps.getJobProperty(InstallSuiteOptionKeys.PRODUCT_SUITE_KEY));
        List<ProductInfo> productInfoList = this.getContextLogic().getApp().getSuiteInfo(suiteType);
        ProductInfo productInfo = null;
        for (ProductInfo info : productInfoList) {
            if (productInfo != null && productInfo.getVersion().compareTo(info.getVersion()) >= 0) continue;
            productInfo = info;
        }
        ArrayList<SchemaInfo> schemas = new ArrayList<SchemaInfo>();
        HashMap<SchemaType, SchemaInfo> schemaMap = new HashMap<SchemaType, SchemaInfo>();
        for (SchemaInfo info : productInfo.getAllSchemas()) {
            schemaMap.put(info.getSchemaType(), info);
        }
        if (product.equals("PM")) {
            schemas.add((SchemaInfo)schemaMap.get((Object)SchemaType.PM));
            schemas.add((SchemaInfo)schemaMap.get((Object)SchemaType.JR));
        } else if (product.equals("PPM")) {
            schemas.add((SchemaInfo)schemaMap.get((Object)SchemaType.PPM));
        } else if (product.equals("MM")) {
            schemas.add((SchemaInfo)schemaMap.get((Object)SchemaType.MM));
        }
        return schemas;
    }

    @Override
    protected ProductSuiteType getProductSuiteType() {
        return ProductSuiteType.PM;
    }

    private class PmProductTypeOp
    implements ConnectionUtil.ConnectionOperation {
        private SchemaType m_schemaType;
        private ProductSuiteType m_productSuiteType;

        private PmProductTypeOp() {
        }

        @Override
        public void performConnectionOperation(DatabaseConnection connection) throws Exception {
            this.m_schemaType = this.getSchemaType(connection);
        }

        private SchemaType getSchemaType(DatabaseConnection connection) throws SchemaTypeNotFoundError {
            if (SetPMPPMUpgradeSchemaInfoListTransOp.this.m_serverType == ServerType.ORACLE) {
                return OracleLogic.getSchemaType(connection, this.m_productSuiteType);
            }
            return SqlServerLogic.getSchemaType(connection, this.m_productSuiteType);
        }

        public SchemaType getSchemaType() {
            return this.m_schemaType;
        }
    }
}

