/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.ProductSuiteType;
import com.primavera.database.common.SchemaInfo;
import com.primavera.database.common.SchemaType;
import com.primavera.database.tools.dbmt.ApplicationContextLogic;
import com.primavera.database.tools.dbmt.ProductInfo;
import com.primavera.database.tools.dbmt.actions.InstallSuiteOptionKeys;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.SetPMPPMSchemaInfoListTransOp;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardRunner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SetPMPPMInstallSchemaInfoListTransOp
extends SetPMPPMSchemaInfoListTransOp {
    private SchemaType m_schemaType;

    public SetPMPPMInstallSchemaInfoListTransOp(ApplicationContextLogic contextLogic, SchemaType schemaType) {
        super(contextLogic);
        this.m_schemaType = schemaType;
    }

    @Override
    protected List<SchemaInfo> getSchemaTypes(WizardInteractorData data, JobProperties jobProps, String product) throws InteractorDataError, SetPMPPMSchemaInfoListTransOp.InvalidSelection {
        ArrayList<SchemaInfo> schemas = new ArrayList<SchemaInfo>();
        ProductInfo productInfo = this.getProductInfo();
        HashMap<SchemaType, SchemaInfo> schemaMap = new HashMap<SchemaType, SchemaInfo>();
        for (SchemaInfo info : productInfo.getAllSchemas()) {
            schemaMap.put(info.getSchemaType(), info);
        }
        schemas.add((SchemaInfo)schemaMap.get((Object)this.m_schemaType));
        return schemas;
    }

    @Override
    protected String getPmProduct(WizardInteractorData data, JobProperties jobProperties) throws InteractorDataError {
        if (this.m_schemaType == SchemaType.PPM) {
            return "PPM";
        }
        if (this.m_schemaType == SchemaType.PM) {
            return "PM";
        }
        return null;
    }

    @Override
    public void unProcess(WizardRunner runner, JobProperties properties) throws InteractorDataError {
        super.unProcess(runner, properties);
        if (this.m_schemaType == SchemaType.PM) {
            properties.clearJobProperty(InstallSuiteOptionKeys.PM_OPTIONS_KEY);
        }
    }

    @Override
    protected ProductSuiteType getProductSuiteType() {
        if (this.m_schemaType == SchemaType.PPM) {
            return ProductSuiteType.PPM;
        }
        return ProductSuiteType.PM;
    }
}

