/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.common.util.EntryPoint;
import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.SuperuserNotFound;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public class SetPMAdminUser {
    private static final String UPDATE_ADMIN_USER_STATEMENT = "UPDATE users SET user_name = ?, passwd = ? WHERE user_id = ?";
    private static final String SELECT_ADMIN_USER_STATEMENT = "SELECT u.user_id id, u.user_name name, p.superuser_flag is_superuser FROM users u, profile p WHERE u.prof_id = p.prof_id";
    private final DatabaseConnection m_conn;

    public SetPMAdminUser(DatabaseConnection conn) {
        this.m_conn = conn;
    }

    public void updateAdminUser(String userName, String passWord) throws Exception {
        String encryptedPassword = EntryPoint.e((String)passWord);
        int adminUserId = this.getSuperuserId(userName);
        this.setAdminUsernameAndPassword(userName, encryptedPassword, adminUserId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAdminUsernameAndPassword(String username, String passWord, int adminUserId) throws SQLException {
        Statement stmt = null;
        try {
            Connection connection = this.m_conn.getConnection();
            stmt = connection.prepareStatement(UPDATE_ADMIN_USER_STATEMENT);
            stmt.setString(1, username);
            stmt.setString(2, passWord);
            stmt.setInt(3, adminUserId);
            stmt.execute();
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getSuperuserId(String newUserName) throws SQLException, DBMTException {
        PreparedStatement stmt = null;
        ResultSet results = null;
        HashMap<String, Integer> superUserMap = new HashMap<String, Integer>();
        try {
            stmt = this.m_conn.getConnection().prepareStatement(SELECT_ADMIN_USER_STATEMENT);
            results = stmt.executeQuery();
            while (results.next()) {
                if (!"Y".equals(results.getString("is_superuser"))) continue;
                superUserMap.put(results.getString("name"), results.getInt("id"));
            }
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (results != null) {
                try {
                    results.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        if (superUserMap.isEmpty()) {
            throw new SuperuserNotFound();
        }
        if (superUserMap.size() == 1) {
            return (Integer)superUserMap.values().iterator().next();
        }
        Map.Entry adminUserEntry = null;
        for (Map.Entry entry : superUserMap.entrySet()) {
            if (!"admin".equalsIgnoreCase((String)entry.getKey())) continue;
            adminUserEntry = entry;
        }
        if (adminUserEntry == null) {
            adminUserEntry = superUserMap.entrySet().iterator().next();
        }
        DBMTLogger.warn(Channel.USER, StringLocalizer.get("dbmt.warn.multiple.adminusers.found", new String[]{(String)adminUserEntry.getKey(), newUserName}));
        return (Integer)adminUserEntry.getValue();
    }
}

