/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.SetConnectStringTransOp;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.dbservers.oracle.OracleServerInfo;
import java.util.Properties;

public class SetOracleConnectStringTransOp
extends SetConnectStringTransOp {
    public SetOracleConnectStringTransOp(ConnectionClass connectionId, boolean verify, Properties fieldOverrides) {
        super(connectionId, verify, fieldOverrides);
    }

    public SetOracleConnectStringTransOp(ConnectionClass connectionId, boolean verify) {
        super(connectionId, verify);
    }

    @Override
    protected String createConnectString(WizardInteractorData data, String page, JobProperties jobProps) throws InteractorDataError, DBMTException {
        String host = this.getFieldId("host");
        String port = this.getFieldId("port");
        String instance = this.getFieldId("instance");
        String ctype = this.getFieldId("ctype");
        String isSysDBAfield = this.getFieldId("sysdba");
        String isSysDBAValue = data.getValue(page, isSysDBAfield);
        boolean isSysDBA = isSysDBAValue.toUpperCase().trim().equals("TRUE");
        OracleServerInfo info = new OracleServerInfo("", "", "");
        info.setHost(data.getValue(page, host));
        info.setPort(Integer.parseInt(data.getValue(page, port)));
        info.setDatabase(data.getValue(page, instance));
        info.setUsername(this.getUsername(page, data, jobProps));
        info.setService(data.getValue(page, ctype).equalsIgnoreCase("SERVICE"));
        info.setSysdba(isSysDBA);
        String connectString = info.createConnectString(this.getPassword(page, data, jobProps));
        return connectString;
    }

    @Override
    protected String createConnectStringATP(WizardInteractorData data, String page, JobProperties jobProps) throws InteractorDataError, DBMTException {
        String configFile = this.getFieldId("dbwallet");
        String service = this.getFieldId("service");
        String username = this.getUsername(page, data, jobProps);
        String dbService = data.getValue(page, service);
        String password = this.getPassword(page, data, jobProps);
        String dbConfigFilePath = data.getValue(page, configFile);
        String connectString = "";
        connectString = dbConfigFilePath.contains(".zip") ? username + "/" + password + "@oracle_atp:" + dbConfigFilePath.substring(0, dbConfigFilePath.indexOf(".zip")) + ":" + dbService : username + "/" + password + "@oracle_atp:" + dbConfigFilePath + ":" + dbService;
        return connectString;
    }

    protected String getUsername(String page, WizardInteractorData data, JobProperties jobProps) throws InteractorDataError, DBMTException {
        String username = this.getFieldId("username");
        return data.getValue(page, username);
    }

    protected String getPassword(String page, WizardInteractorData data, JobProperties jobProps) throws InteractorDataError, DBMTException {
        String password = this.getFieldId("password");
        return data.getValue(page, password);
    }
}

