/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class SetHostnameToCurrentMachine
implements TransitionMap.PageInitializer {
    private final String m_hostNameFieldId;

    public SetHostnameToCurrentMachine(String hostFieldId) {
        this.m_hostNameFieldId = hostFieldId;
    }

    @Override
    public String initializePage(JobProperties jobProps, WizardInteractorData data, String page) throws InteractorDataError {
        String currentHostValue = data.getValue(page, this.m_hostNameFieldId);
        if (currentHostValue != null) {
            return null;
        }
        try {
            InetAddress localMachine = InetAddress.getLocalHost();
            data.getPageData(page).setValue(this.m_hostNameFieldId, localMachine.getHostName());
        }
        catch (UnknownHostException e) {
            DBMTLogger.warn(Channel.DEV, "Unable to get hostname?  " + e.getClass().getSimpleName() + ": " + e.getMessage());
        }
        return null;
    }
}

