/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.common.P6KeyManager;
import com.primavera.common.util.EntryPoint;
import com.primavera.database.common.ServerType;
import com.primavera.database.common.connection.ConnectStringParse;
import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.BaseServerInfo;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardRunner;
import com.primavera.database.tools.dbmt.dbservers.mssql.MSSqlServerInfo;
import com.primavera.database.tools.dbmt.dbservers.oracle.OracleServerInfo;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;

public abstract class SetConnectStringTransOp
implements TransitionMap.TransitionOperation {
    private static final Properties EMPTY_FIELD_OVERRIDES = new Properties();
    private final ConnectionClass m_connectionClass;
    private final Properties m_fieldOverrides;
    protected boolean m_verify;

    public SetConnectStringTransOp(ConnectionClass connectionClass, boolean verify, Properties fieldOverrides) {
        this.m_connectionClass = connectionClass;
        this.m_verify = verify;
        this.m_fieldOverrides = fieldOverrides;
    }

    public SetConnectStringTransOp(ConnectionClass connectionClass, boolean verify) {
        this(connectionClass, verify, EMPTY_FIELD_OVERRIDES);
    }

    @Override
    public void unProcess(WizardRunner runner, JobProperties properties) throws InteractorDataError {
        properties.clearConnection(this.m_connectionClass);
    }

    protected abstract String createConnectString(WizardInteractorData var1, String var2, JobProperties var3) throws InteractorDataError, Exception;

    protected abstract String createConnectStringATP(WizardInteractorData var1, String var2, JobProperties var3) throws InteractorDataError, Exception;

    public String getPage(String currentPage) {
        return currentPage;
    }

    @Override
    public String process(WizardRunner runner, WizardInteractorData data, String currentPage, JobProperties properties) throws InteractorDataError {
        String connectionPage = this.getPage(currentPage);
        try {
            ArrayList<String> pageIds = new ArrayList<String>();
            pageIds.addAll(data.getPageIds());
            if (pageIds.contains("operation_pm")) {
                String server = data.getValue("operation_pm", this.getFieldId("servertype"));
                if (server.equalsIgnoreCase("OR_ATP")) {
                    properties.setConnection(this.m_connectionClass, this.createConnectStringATP(data, connectionPage, properties));
                } else {
                    properties.setConnection(this.m_connectionClass, this.createConnectString(data, connectionPage, properties));
                }
            } else {
                properties.setConnection(this.m_connectionClass, this.createConnectString(data, connectionPage, properties));
            }
        }
        catch (Exception e) {
            return e.getClass().getSimpleName() + ": " + e.getLocalizedMessage() + " (" + e.getMessage() + ")";
        }
        String connectString = null;
        try {
            connectString = properties.getConnection(this.m_connectionClass);
        }
        catch (ConnectionNotFoundException e1) {
            return StringLocalizer.get("dbmt.error.connection.not.defined", new String[]{this.m_connectionClass.toString()});
        }
        if (!this.m_verify) {
            return null;
        }
        try {
            this.verifyConnection(connectString);
        }
        catch (SQLException e) {
            return e.getClass().getSimpleName() + ": " + e.getLocalizedMessage();
        }
        if (currentPage.equalsIgnoreCase("connect_upgrade_or_user") || currentPage.equalsIgnoreCase("connect_upgrade_ss")) {
            try {
                P6KeyManager.getInstance().clearAllCachedKeys();
                this.verifyPrivuserforDecryption(connectString);
            }
            catch (Exception e) {
                P6KeyManager.getInstance().clearAllCachedKeys();
                return StringLocalizer.get("dbmt.error.keystore.encryption.failed");
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyConnection(String connectString) throws SQLException {
        DatabaseConnection connection = null;
        try {
            connection = new DatabaseConnection(connectString);
            connection.getConnection();
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    DBMTLogger.warn(Channel.USER, e.getLocalizedMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String verifyPrivuserforDecryption(String connectString) throws Exception {
        DatabaseConnection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            connection = new DatabaseConnection(connectString);
            ps = connection.getConnection().prepareStatement("select private_db_user_name, private_db_passwd from pubuser where public_group_id = ?");
            ps.setInt(1, Integer.parseInt("1"));
            rs = ps.executeQuery();
            if (rs.next()) {
                String privUser = rs.getString(1);
                String privPass = EntryPoint.d((String)rs.getString(2));
                if (privPass == null) {
                    throw new Exception();
                }
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    DBMTLogger.warn(Channel.USER, e.getLocalizedMessage());
                }
            }
        }
        return null;
    }

    protected String getFieldId(String fieldCanonicalName) {
        String fieldOverride = this.m_fieldOverrides.getProperty(fieldCanonicalName);
        if (fieldOverride == null) {
            return fieldCanonicalName;
        }
        return fieldOverride;
    }

    protected String createConnectionFromExistingConnectionForNewUser(String existingConnection, String userName, String password) throws ConnectionNotFoundException {
        ConnectStringParse parsedConnection = new ConnectStringParse(existingConnection);
        String host = parsedConnection.getServer();
        String port = parsedConnection.getPort();
        String instance = parsedConnection.getDatabase();
        BaseServerInfo info = null;
        if (parsedConnection.getDbtype() == ServerType.ORACLE) {
            info = new OracleServerInfo("", "", "");
        }
        if (parsedConnection.getDbtype() == ServerType.SQLSERVER) {
            info = new MSSqlServerInfo("", "");
        }
        info.setHost(host);
        info.setPort(Integer.parseInt(port));
        info.setDatabase(instance);
        info.setUsername(userName);
        info.setService(parsedConnection.isOracleService());
        String connectionString = info.createConnectString(password);
        return connectionString;
    }
}

