/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.common.util.EntryPoint;
import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

@Deprecated
public class ReEncryptPrivuserPassword {
    public static final String SELECT_PRIVUSER_QUERY = "SELECT private_db_user_name un, private_db_passwd pw FROM pubuser";
    private final DatabaseConnection m_conn;

    public ReEncryptPrivuserPassword(DatabaseConnection conn) {
        this.m_conn = conn;
    }

    public void encryptPrivuserPassword(String query, String tablename) throws Exception {
        DBMTLogger.info(Channel.DEV, "Calling " + this.getClass().getSimpleName() + ".encryptSqlServerPrivuserPassword");
        try (Statement stmt = this.m_conn.getConnection().createStatement();
             ResultSet results = stmt.executeQuery(query);){
            ArrayList<UserInfo> users = new ArrayList<UserInfo>();
            while (results.next()) {
                users.add(new UserInfo(results.getString("un"), results.getString("pw")));
            }
            for (UserInfo user : users) {
                this.reEncryptPassword(user.username, user.password, tablename);
            }
        }
        catch (RuntimeException e) {
            DBMTLogger.error(Channel.DEV, this.getClass().getSimpleName() + ".updateUserPasswords: threw exception", e);
            DBMTLogger.error(Channel.USER, StringLocalizer.get("dbmt.action.error.error.reencrypt.pass"));
            throw e;
        }
    }

    public void encryptSqlServerPrivuserPassword() throws Exception {
        this.encryptPrivuserPassword(SELECT_PRIVUSER_QUERY, "pubuser");
    }

    public void encryptOraclePrivuserPassword(String pubusername) throws Exception {
        this.encryptPrivuserPassword(this.createOraclePrivuserTableQuery(pubusername), pubusername + ".pubuser");
    }

    private void reEncryptPassword(String uname, String pword, String tableName) {
        String updateStatement = "UPDATE " + tableName + " SET private_db_passwd = ? WHERE private_db_user_name = ?";
        try (PreparedStatement stmt = this.m_conn.getConnection().prepareStatement(updateStatement);){
            stmt.setString(1, EntryPoint.f((String)pword));
            stmt.setString(2, uname);
            stmt.execute();
            Connection conn = this.m_conn.getConnection();
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
        }
        catch (SQLException e) {
            DBMTLogger.info(Channel.DEV, "Error issuing update statement : " + updateStatement, e);
            DBMTLogger.info(Channel.USER, StringLocalizer.get("dbmt.update.private.database.error.sql.update.error", new String[]{updateStatement, e.toString()}));
        }
        catch (Exception e) {
            DBMTLogger.error(Channel.DEV, "Error encrypting password for " + uname, e);
            DBMTLogger.error(Channel.USER, StringLocalizer.get("dbmt.update.private.database.error.encrypting.password"));
        }
    }

    private String createOraclePrivuserTableQuery(String privusername) {
        return "SELECT private_db_user_name un, private_db_passwd pw FROM " + privusername + ".pubuser";
    }

    private static class UserInfo {
        public final String username;
        public final String password;

        public UserInfo(String u, String p) {
            this.username = u;
            this.password = p;
        }
    }
}

