/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.ContextLogic;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.WizardActionOperation;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardProgressor;
import com.primavera.database.tools.dbmt.actions.WizardRunner;
import java.util.HashMap;
import java.util.Map;

public abstract class NavigationalWizardAction<T extends ContextLogic>
extends WizardActionOperation<T> {
    public Map<String, WizardProgressor> m_map = new HashMap<String, WizardProgressor>();

    public NavigationalWizardAction(T contextLogic) {
        super(contextLogic);
    }

    public final void addPage(WizardProgressor action) {
        this.m_map.put(action.getPage(), action);
    }

    @Override
    public final String tryToLeavePage(WizardRunner runner, WizardInteractorData data, JobProperties jobProps, String fromPageId, String toPageId) throws InteractorDataError {
        DBMTLogger.info(Channel.DEV, "Proceeding from page " + fromPageId + " to page " + toPageId);
        WizardProgressor progressor = this.m_map.get(fromPageId);
        if (progressor == null) {
            return null;
        }
        DBMTLogger.info(Channel.DEV, "Using progressor " + progressor.getClass().getSimpleName() + " for page " + fromPageId);
        return progressor.proceed(runner, data, jobProps);
    }

    @Override
    public final void undoPage(WizardRunner runner, WizardInteractorData data, JobProperties jobProps, String fromPageId, String toPageId) throws InteractorDataError {
        WizardProgressor progressor = this.m_map.get(toPageId);
        if (progressor == null) {
            return;
        }
        progressor.undo(runner, data, jobProps);
    }

    @Override
    public void preparePage(WizardRunner runner, WizardInteractorData data, JobProperties jobProps, String pageId) throws InteractorDataError {
        WizardProgressor progressor = this.m_map.get(pageId);
        if (progressor == null) {
            return;
        }
        progressor.preparePage(runner, data, jobProps);
    }
}

