/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.JobPropertyNotFound;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class JobProperties {
    private final Properties m_scriptProperties = new Properties(){
        private static final long serialVersionUID = 6572971056176929434L;

        @Override
        public Object put(Object k, Object v) {
            return super.put(k, v);
        }

        @Override
        public synchronized void putAll(Map<? extends Object, ? extends Object> map) {
            super.putAll(map);
        }
    };
    private final Properties m_jobProperties = new Properties(){
        private static final long serialVersionUID = 6572971056176929434L;

        @Override
        public Object put(Object k, Object v) {
            return super.put(k, v);
        }

        @Override
        public synchronized void putAll(Map<? extends Object, ? extends Object> map) {
            super.putAll(map);
        }
    };
    private final Map<ConnectionClass, String> m_connections = new HashMap<ConnectionClass, String>();

    public JobProperties() {
        this.m_jobProperties.putAll((Map<?, ?>)JobProperties.getDefaultJobProperties());
    }

    private static Properties getDefaultJobProperties() {
        Properties props = new Properties();
        props.put("unicode", "");
        return props;
    }

    public final Object getJobProperty(Object propKey) throws JobPropertyNotFound {
        Object propValue = this.m_jobProperties.get(propKey);
        if (propValue == null) {
            throw new JobPropertyNotFound(propKey);
        }
        return propValue;
    }

    public final void setJobProperty(Object propKey, Object propValue) {
        this.m_jobProperties.put(propKey, propValue);
    }

    public final void setJobProperties(Properties props) {
        this.m_jobProperties.putAll((Map<?, ?>)props);
    }

    public final void clearJobProperty(Object key) {
        this.m_jobProperties.remove(key);
    }

    public final Properties getScriptProperties() {
        return this.m_scriptProperties;
    }

    public final void setConnection(ConnectionClass connectionType, String connectString) {
        this.m_connections.put(connectionType, connectString);
    }

    public final String getConnection(ConnectionClass connectionType) throws ConnectionNotFoundException {
        String connectString = this.m_connections.get((Object)connectionType);
        if (connectString == null) {
            throw new ConnectionNotFoundException(connectionType);
        }
        return connectString;
    }

    public void clearConnection(ConnectionClass connectionId) {
        this.m_connections.remove((Object)connectionId);
    }

    public Collection<Map.Entry<Object, Object>> getJobPropertyEntries() {
        return this.m_jobProperties.entrySet();
    }

    public Properties cloneJobProperties() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.m_jobProperties);
        return props;
    }
}

