/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.common.KeyStoreInstaller;
import com.primavera.common.StrUtil;
import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.RunnerFactoryManager;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardRunner;
import com.primavera.database.tools.dbmt.cmd.CmdLineWizardRunnerFactory;
import java.io.File;

public class CreateKeyStoreTransOp
implements TransitionMap.TransitionOperation {
    static String[] installedProject = new String[]{"p6", "p6procloudconnect", "tmws", "ws", "api"};

    @Override
    public String process(WizardRunner runner, WizardInteractorData data, String page, JobProperties jobProps) throws InteractorDataError, ValueNotFound, ConnectionNotFoundException, DBMTException {
        KeyStoreInstaller ks;
        boolean verified;
        if (RunnerFactoryManager.inst().getWizardRunnerFactory().getClass().equals(CmdLineWizardRunnerFactory.class)) {
            return null;
        }
        jobProps.setJobProperty("merge", Boolean.FALSE.toString());
        jobProps.setJobProperty("useExisting", Boolean.FALSE.toString());
        jobProps.setJobProperty("createNew", Boolean.FALSE.toString());
        jobProps.setJobProperty("copyKeyStore", Boolean.FALSE.toString());
        String keyStoreFolder = StrUtil.trim((String)((String)jobProps.getJobProperty("keyStoreFolder")));
        String oldPassword = StrUtil.trim((String)data.getValue(page, "oldKsPassword"));
        String newPassword = StrUtil.trim((String)data.getValue(page, "ksPassword"));
        boolean keyStoreFolderDefault = this.isKeyStoreFolderDefault(keyStoreFolder);
        if (!StrUtil.isEmpty((String)keyStoreFolder) && !keyStoreFolderDefault && this.isDefaultFolderContainsKeyStore()) {
            return StringLocalizer.get("dbmt.error.keystore.defaultkeystore.present");
        }
        if (!StrUtil.isEmpty((String)keyStoreFolder) && !keyStoreFolderDefault && StrUtil.isEmpty((String)oldPassword)) {
            return StringLocalizer.get("dbmt.error.keystore.existing.keystore.blank");
        }
        if (StrUtil.isEmpty((String)keyStoreFolder) && !StrUtil.isEmpty((String)oldPassword)) {
            return StringLocalizer.get("dbmt.error.keystore.existing.keystore.not.required");
        }
        if (!StrUtil.isEmpty((String)oldPassword) && !(verified = (ks = new KeyStoreInstaller()).verifyPassword(keyStoreFolder, oldPassword))) {
            return StringLocalizer.get("dbmt.error.keystore.password.validation.failed");
        }
        if (data.getValue(page, "createKeystore").toUpperCase().equals(Boolean.TRUE.toString().toUpperCase()) && !StrUtil.isEmpty((String)keyStoreFolder)) {
            if (StrUtil.isEmpty((String)StrUtil.trim((String)data.getValue(page, "oldKsPassword")))) {
                return StringLocalizer.get("dbmt.error.keystore.existing.keystore.blank");
            }
            jobProps.setJobProperty("merge", Boolean.TRUE.toString());
            jobProps.setJobProperty("copyKeyStore", Boolean.TRUE.toString());
            jobProps.setJobProperty("newpassword", data.getValue(page, "ksPassword"));
        } else if (data.getValue(page, "createKeystore").toUpperCase().equals(Boolean.TRUE.toString().toUpperCase())) {
            jobProps.setJobProperty("createNew", Boolean.TRUE.toString());
            jobProps.setJobProperty("copyKeyStore", Boolean.TRUE.toString());
            jobProps.setJobProperty("newpassword", newPassword);
            jobProps.setJobProperty("generate", true);
        } else if (!StrUtil.isEmpty((String)((String)jobProps.getJobProperty("keyStoreFolder"))) && !keyStoreFolderDefault) {
            jobProps.setJobProperty("useExisting", Boolean.TRUE.toString());
            jobProps.setJobProperty("copyKeyStore", Boolean.TRUE.toString());
        }
        if (!StrUtil.isEmpty((String)oldPassword)) {
            jobProps.setJobProperty("keyStoreFolder", keyStoreFolder);
            jobProps.setJobProperty("oldKsPassword", oldPassword);
        }
        if (oldPassword != null || newPassword != null) {
            jobProps.setJobProperty("copyPassword", StrUtil.isEmpty((String)newPassword) ? oldPassword : newPassword);
        }
        jobProps.setJobProperty("installedProject", installedProject);
        jobProps.setJobProperty("sourceFolder", "database");
        return null;
    }

    private boolean isKeyStoreFolderDefault(String keyStoreFolder) {
        boolean isDefaultPath = false;
        String defaultPath = System.getProperty("user.dir");
        if (keyStoreFolder.equalsIgnoreCase(defaultPath)) {
            isDefaultPath = true;
        }
        return isDefaultPath;
    }

    private boolean isDefaultFolderContainsKeyStore() {
        boolean fileExist = false;
        File ks = new File(System.getProperty("user.dir") + "/p6keystore.jks");
        if (ks.exists()) {
            fileExist = true;
        }
        return fileExist;
    }

    @Override
    public void unProcess(WizardRunner runner, JobProperties properties) throws InteractorDataError {
        properties.clearJobProperty("merge");
        properties.clearJobProperty("useExisting");
        properties.clearJobProperty("createNew");
        properties.clearJobProperty("password");
        properties.clearJobProperty("generate");
        properties.clearJobProperty("oldKsPassword");
    }
}

