/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.tools.dbmt.actions.InvalidValueString;
import com.primavera.database.tools.dbmt.actions.TypedTypeDef;

public class BooleanTypeDef
extends TypedTypeDef<Boolean> {
    private static final BooleanTypeDef s_instance = new BooleanTypeDef();

    private BooleanTypeDef() {
        super(Boolean.class);
    }

    public static BooleanTypeDef inst() {
        return s_instance;
    }

    @Override
    protected Boolean readValue(String o) throws InvalidValueString {
        if (o.toUpperCase().equals(Boolean.TRUE.toString().toUpperCase())) {
            return new Boolean(true);
        }
        if (o.toUpperCase().equals(Boolean.FALSE.toString().toUpperCase())) {
            return new Boolean(false);
        }
        throw new InvalidValueString(this, o, "dbmt.typedef.error.notboolean");
    }

    @Override
    public String getNomalizedString(String s) {
        if (s == null) {
            return s;
        }
        if (s.toUpperCase().equals(Boolean.TRUE.toString().toUpperCase())) {
            return "TRUE";
        }
        if (s.toUpperCase().equals(Boolean.FALSE.toString().toUpperCase())) {
            return "FALSE";
        }
        return s;
    }
}

