/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt;

import com.primavera.database.tools.dbmt.gui.MenuSpec;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MenuSpecXMLParserHandler
extends DefaultHandler {
    public static final String ELEM_MENU = "menu";
    public static final String ELEM_SUBMENU = "submenu";
    public static final String ELEM_ITEM = "item";
    public static final String ATTR_ID = "id";
    public static final String ATTR_TITLE = "title";
    public static final String ATTR_DESC = "desc";
    public static final String ATTR_CLASS = "class";
    public static final String ATTR_ACTION = "action";
    private final MenuSpec m_menuSpec;
    private final List<MenuSpec.DecoratedObject> m_topLevelObjects;
    private final List<MenuSpec.DecoratedActionSet> m_nodeStack = new ArrayList<MenuSpec.DecoratedActionSet>();
    private final List<String> m_nameStack = new ArrayList<String>();

    public MenuSpecXMLParserHandler(MenuSpec menuSpec) {
        this.m_menuSpec = menuSpec;
        this.m_topLevelObjects = this.m_menuSpec.getTopLevelEntries();
    }

    public List<MenuSpec.DecoratedObject> currentNode() {
        if (this.m_nodeStack.isEmpty()) {
            return this.m_topLevelObjects;
        }
        return this.m_nodeStack.get(this.m_nodeStack.size() - 1).getSubObjects();
    }

    private void push(String name, MenuSpec.DecoratedActionSet node) {
        this.m_nameStack.add(name);
        this.m_nodeStack.add(node);
    }

    private void pop() {
        this.m_nameStack.remove(this.m_nameStack.size() - 1);
        this.m_nodeStack.remove(this.m_nodeStack.size() - 1);
    }

    private String getPropertyPath() {
        StringBuffer sb = new StringBuffer(ELEM_MENU);
        for (String name : this.m_nameStack) {
            sb.append("." + name);
        }
        return sb.toString();
    }

    private String getItemNameProperty(String id) {
        return this.getPropertyPath() + ".item." + id + ".name";
    }

    private String getItemDescProperty(String id) {
        return this.getPropertyPath() + ".item." + id + ".desc";
    }

    private String getMenuNameProperty(String id) {
        return this.getPropertyPath() + "." + id + ".name";
    }

    private String getMenuDescProperty(String id) {
        return this.getPropertyPath() + "." + id + ".desc";
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String id = attributes.getValue(ATTR_ID);
        if (!qName.equals(ELEM_MENU)) {
            if (qName.equals(ELEM_SUBMENU)) {
                MenuSpec.DecoratedActionSet actionSet = this.m_menuSpec.createDecoratedActionSet(this.getMenuNameProperty(id), this.getMenuDescProperty(id), new ArrayList<MenuSpec.DecoratedObject>());
                this.currentNode().add(actionSet);
                this.push(attributes.getValue(ATTR_ID), actionSet);
            } else if (qName.equals(ELEM_ITEM)) {
                String actionString = attributes.getValue(ATTR_ACTION);
                MenuSpec.DecoratedActionObject actionObject = this.m_menuSpec.createDecoratedActionObject(this.getItemNameProperty(id), this.getItemDescProperty(id), actionString);
                this.currentNode().add(actionObject);
            }
        }
        super.startElement(uri, localName, qName, attributes);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals(ELEM_SUBMENU)) {
            this.pop();
        }
    }
}

