/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt;

import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.ExtentionLoadedListener;
import com.primavera.database.tools.dbmt.ExtentionLoader;
import com.primavera.database.tools.dbmt.xml.util.NodeHandler;
import com.primavera.database.tools.dbmt.xml.util.NodeLink;
import com.primavera.database.tools.dbmt.xml.util.SimpleHandler;
import com.primavera.database.tools.dbmt.xml.util.extentions.nodes.ExtentionNode;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class ExtentionManager {
    private static final ExtentionManager s_inst = new ExtentionManager();
    private final Map<String, ExtentionLoader> s_loaders = new HashMap<String, ExtentionLoader>();
    private final Set<ExtentionLoadedListener> s_listeners = new HashSet<ExtentionLoadedListener>();
    private final Map<String, Collection<String>> m_extentionFiles = new HashMap<String, Collection<String>>();

    private ExtentionManager() {
        for (String extention : this.s_loaders.keySet()) {
            this.m_extentionFiles.put(extention, new HashSet());
        }
    }

    public static ExtentionManager inst() {
        return s_inst;
    }

    public void loadExtention(String extentionFilePath) {
        final ExtentionManager extentionMgr = new ExtentionManager();
        try {
            InputStream input = ClassLoader.getSystemClassLoader().getResourceAsStream(extentionFilePath);
            if (input == null) {
                DBMTLogger.error(Channel.DEV, "Unable to find the resource (" + extentionFilePath + ") for extention");
                return;
            }
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(input, (DefaultHandler)new SimpleHandler(new NodeLink(){

                @Override
                public NodeHandler nextNode(String elemName, Attributes attr) {
                    if ("extention".equals(elemName)) {
                        return new ExtentionNode(extentionMgr);
                    }
                    return null;
                }

                @Override
                public String path() {
                    return "";
                }
            }));
        }
        catch (Throwable e) {
            DBMTLogger.error(Channel.USER, "Unable to load extention from " + extentionFilePath + ": " + e);
            e.printStackTrace();
        }
        ExtentionManager.inst().fireExtentionLoaded(extentionMgr);
        ExtentionManager.inst().merge(extentionMgr);
    }

    private void merge(ExtentionManager extentionMgr) {
        for (Map.Entry<String, Collection<String>> entry : extentionMgr.m_extentionFiles.entrySet()) {
            Collection<String> resources = this.m_extentionFiles.get(entry.getKey());
            if (resources == null) {
                resources = new HashSet<String>();
                this.m_extentionFiles.put(entry.getKey(), resources);
            }
            resources.addAll(entry.getValue());
        }
    }

    public void addExtentionResource(String extentionType, String resource) {
        Collection<String> files = this.m_extentionFiles.get(extentionType);
        if (files == null) {
            files = new HashSet<String>();
            this.m_extentionFiles.put(extentionType, files);
        }
        files.add(resource);
    }

    public Iterable<String> getExtentionResources(String extentionType) {
        Collection<String> resources = this.m_extentionFiles.get(extentionType);
        if (resources != null) {
            return resources;
        }
        return new ArrayList<String>();
    }

    public ExtentionLoader findLoader(String elemName) {
        return this.s_loaders.get(elemName);
    }

    public void addLoader(String elemName, ExtentionLoader loader) {
        if (this.s_loaders.keySet().contains(elemName)) {
            DBMTLogger.error(Channel.DEV, "Extention " + elemName + " already exists");
            return;
        }
        this.s_loaders.put(elemName, loader);
    }

    public synchronized void fireExtentionLoaded(ExtentionManager extentions) {
        for (ExtentionLoadedListener listener : this.s_listeners) {
            listener.onExtentionLoaded(extentions);
        }
    }

    public synchronized void addListener(ExtentionLoadedListener listener) {
        if (!this.s_listeners.contains(listener)) {
            this.s_listeners.add(listener);
        }
    }
}

