/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt;

import com.primavera.database.common.ServerType;
import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.tools.dbmt.ServerInfo;
import java.sql.SQLException;
import java.util.Properties;

public abstract class BaseServerInfo
implements ServerInfo {
    private String m_name;
    private String m_host;
    private int m_port;
    private String m_user;
    private String m_password;
    private String m_database;
    private Boolean m_service;
    private DatabaseConnection m_connection;
    private boolean m_sysdba = false;

    public void setSysdba(boolean m_sysdba) {
        this.m_sysdba = m_sysdba;
    }

    protected BaseServerInfo(String name, String host) {
        this.m_name = name;
        this.m_host = host;
        this.m_port = this.getType().getDefaultPortNumber();
        this.m_user = this.getType().getAdministratorName();
        this.m_service = false;
        this.m_password = "";
        this.m_database = this.getType().getDefaultDb();
    }

    protected static final String quote(String str, char quoteChar) {
        return Character.toString(quoteChar) + str + Character.toString(quoteChar);
    }

    @Override
    public final String createConnectString(String password, String database) {
        String username = this.getType().getUsername(this.getUsername());
        if (this.m_sysdba) {
            username = username + ":sysdba";
        }
        String server = this.getHost();
        String port = Integer.toString(this.getType().getPort(this.getPort()));
        String connectString = username + "/" + password + "@" + this.getType().getConnectionTypeName() + ":" + server + ":" + port + (this.m_service != false ? "/" : ":") + database;
        return connectString;
    }

    @Override
    public final String createConnectString(String password) {
        return this.createConnectString(password, this.m_database);
    }

    @Override
    public final String createATPConnectString(String password) {
        String connectString = "";
        try {
            String username = this.getType().getUsername(this.getUsername());
            String configFile = this.getHost();
            connectString = username + "/" + password + "@oracle_atp:" + configFile + ":" + this.m_database;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while retriving wallet file name");
        }
        return connectString;
    }

    @Override
    public final String createATPConnectString(String password, String baseConnectString) {
        String connectString = "";
        try {
            String username = this.getType().getUsername(this.getUsername());
            int startIndex = baseConnectString.lastIndexOf("oracle_atp:");
            int endIndex = baseConnectString.lastIndexOf(":");
            String configFile = baseConnectString.substring(startIndex + "oracle_atp:".length(), endIndex);
            connectString = username + "/" + password + "@oracle_atp:" + configFile + ":" + this.m_database;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while retriving wallet file name");
        }
        return connectString;
    }

    @Override
    public final DatabaseConnection getConnection() {
        return this.m_connection;
    }

    @Override
    public final String getHost() {
        return this.m_host;
    }

    @Override
    public final String getName() {
        return this.m_name;
    }

    @Override
    public final int getPort() {
        return this.m_port;
    }

    @Override
    public final String getUsername() {
        return this.m_user;
    }

    public final void setHost(String host) {
        this.m_host = host;
    }

    public final void setName(String name) {
        this.m_name = name;
    }

    public final void setPort(int port) {
        this.m_port = port;
    }

    public final void setUsername(String user) {
        this.m_user = user;
    }

    public final void setService(Boolean service) {
        this.m_service = service;
    }

    @Override
    public final boolean getService() {
        return this.m_service;
    }

    @Override
    public final boolean isConnected() {
        return this.m_connection != null;
    }

    public int hashCode() {
        return (this.getType().hashCode() + this.m_host.hashCode() + this.m_port + this.m_user.hashCode()) % Integer.MAX_VALUE;
    }

    @Override
    public final void connect(String password) throws SQLException {
        this.setConnection(this.createConnectString(password));
    }

    private void setConnection(String connectString) throws SQLException {
        if (this.m_connection != null) {
            this.m_connection.close();
        }
        this.m_connection = new DatabaseConnection(connectString);
    }

    @Override
    public final void connect(String password, String database) throws SQLException {
        this.setConnection(this.createConnectString(password, database));
    }

    @Override
    public void disconnect() {
        if (this.m_connection == null) {
            return;
        }
        try {
            this.m_connection.close();
            this.m_connection = null;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof ServerInfo) {
            ServerInfo server = (ServerInfo)obj;
            if (ServerType.SQLSERVER != server.getType()) {
                return false;
            }
            if (!this.m_host.equals(server.getHost())) {
                return false;
            }
            if (this.m_port != server.getPort()) {
                return false;
            }
            return this.m_user.equals(server.getUsername());
        }
        return false;
    }

    public String toString() {
        return this.m_name + " (" + this.m_user + "@" + this.m_host + ":" + this.m_port + ")";
    }

    @Override
    public Properties serverProperties() {
        Properties props = new Properties();
        props.put("name", this.m_name);
        props.put("host", this.m_host);
        props.put("port", Integer.toString(this.m_port));
        props.put("user", this.m_user);
        props.put("database", this.m_database);
        return props;
    }

    @Override
    public String getDatabase() {
        return this.m_database;
    }

    public final void setDatabase(String database) {
        this.m_database = database;
    }

    @Override
    public String getPassword() {
        return this.m_password;
    }

    public void setPassword(String m_password) {
        this.m_password = m_password;
    }
}

