/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt;

import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.ActionLogicManager;
import com.primavera.database.tools.dbmt.ActionLogicManagerImpl;
import com.primavera.database.tools.dbmt.ActionLogicTreeNode;
import com.primavera.database.tools.dbmt.ActionOperation;
import com.primavera.database.tools.dbmt.StaticForward;
import com.primavera.database.tools.dbmt.SwitchForward;
import com.primavera.database.tools.dbmt.actions.BooleanTypeDef;
import com.primavera.database.tools.dbmt.actions.CommitPageDataDef;
import com.primavera.database.tools.dbmt.actions.EnumDataEntry;
import com.primavera.database.tools.dbmt.actions.EnumTypeDef;
import com.primavera.database.tools.dbmt.actions.FieldTester;
import com.primavera.database.tools.dbmt.actions.ForwardLogic;
import com.primavera.database.tools.dbmt.actions.IntegerTypeDef;
import com.primavera.database.tools.dbmt.actions.InteractorData;
import com.primavera.database.tools.dbmt.actions.InteractorDataDef;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.InvalidDialogField;
import com.primavera.database.tools.dbmt.actions.PasswordTypeDef;
import com.primavera.database.tools.dbmt.actions.SelectTypeDef;
import com.primavera.database.tools.dbmt.actions.StringTypeDef;
import com.primavera.database.tools.dbmt.actions.TextDefinition;
import com.primavera.database.tools.dbmt.actions.TypeDef;
import com.primavera.database.tools.dbmt.actions.ValueDef;
import com.primavera.database.tools.dbmt.actions.WizardFactory;
import com.primavera.database.tools.dbmt.actions.WizardInteractorDataDef;
import com.primavera.database.tools.dbmt.actions.WizardNavigationAction;
import com.primavera.database.tools.dbmt.actions.tests.TestOp;
import com.primavera.database.tools.dbmt.cmd.UnableToInitializeCommands;
import com.primavera.database.tools.dbmt.xml.util.SimpleHandler;
import com.primavera.database.tools.dbmt.xml.util.actions.ActionHandlerRootNode;
import com.primavera.database.tools.dbmt.xml.util.actions.FileTypeDef;
import com.primavera.schema.pmdbs.action._1.TAction;
import com.primavera.schema.pmdbs.action._1.TActionSet;
import com.primavera.schema.pmdbs.action._1.TBoolField;
import com.primavera.schema.pmdbs.action._1.TCase;
import com.primavera.schema.pmdbs.action._1.TCommitPage;
import com.primavera.schema.pmdbs.action._1.TContext;
import com.primavera.schema.pmdbs.action._1.TEnumField;
import com.primavera.schema.pmdbs.action._1.TEnumValue;
import com.primavera.schema.pmdbs.action._1.TFileField;
import com.primavera.schema.pmdbs.action._1.TFinish;
import com.primavera.schema.pmdbs.action._1.TForward;
import com.primavera.schema.pmdbs.action._1.TImport;
import com.primavera.schema.pmdbs.action._1.TIntField;
import com.primavera.schema.pmdbs.action._1.TPage;
import com.primavera.schema.pmdbs.action._1.TRemapField;
import com.primavera.schema.pmdbs.action._1.TRemapValue;
import com.primavera.schema.pmdbs.action._1.TStatic;
import com.primavera.schema.pmdbs.action._1.TStringField;
import com.primavera.schema.pmdbs.action._1.TSwitch;
import com.primavera.schema.pmdbs.action._1.TTemplateReference;
import com.primavera.schema.pmdbs.action._1.TTest;
import com.primavera.schema.pmdbs.action._1.TTestField;
import com.primavera.schema.pmdbs.action._1.TTestParam;
import com.primavera.schema.pmdbs.action._1.TTestSet;
import com.primavera.schema.pmdbs.action._1.TTextField;
import com.primavera.schema.pmdbs.action._1.TTextSubstitution;
import com.primavera.schema.pmdbs.action._1.TWizard;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ActionLoader {
    private static final String ELEM_NAME_PASSWORD = "password";
    private static final String ELEM_NAME_STRING = "string";
    private static final String ELEM_NAME_SELECT = "select";
    private static final String ELEM_NAME_BOOL = "bool";
    private static final String ELEM_NAME_ENUM = "enum";
    private static final String ELEM_NAME_ENUMVALUE = "value";
    private static final String ATTR_NAME_ID = "id";
    private static final String ELEM_NAME_TEMPLATE = "template";
    private static final String TEMP_ACTION_DEF_PKG = "com.primavera.schema.pmdbs.action._1";
    private static final Set<EnumDataEntry> emptySelectValues = new HashSet<EnumDataEntry>();

    public static ActionLogicManager loadFromResource(String resourceName) {
        return ActionLoader.newLoadFromResource(resourceName);
    }

    public static ActionLogicManager oldLoadFromResource(String resourceName) {
        ActionLogicManagerImpl actionLogicMgr = new ActionLogicManagerImpl();
        try {
            InputStream input = ClassLoader.getSystemClassLoader().getResourceAsStream(resourceName);
            if (input == null) {
                DBMTLogger.error(Channel.DEV, "Unable to find the resource (" + resourceName + ") from property " + resourceName);
                return actionLogicMgr;
            }
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(input, (DefaultHandler)new SimpleHandler(new ActionHandlerRootNode(actionLogicMgr)));
            return actionLogicMgr;
        }
        catch (Throwable e) {
            DBMTLogger.error(Channel.USER, "Unable to load actions from " + resourceName + ": " + e);
            e.printStackTrace();
            return actionLogicMgr;
        }
    }

    public static ActionLogicManager newLoadFromResource(String resourceName) {
        ActionLogicManager actionLogicMgr = ActionLogicManagerImpl.inst();
        try {
            JAXBContext ctx = JAXBContext.newInstance((String)TEMP_ACTION_DEF_PKG);
            Unmarshaller unmarshaller = ctx.createUnmarshaller();
            InputStream input = ClassLoader.getSystemResourceAsStream(resourceName);
            if (input == null) {
                throw new UnableToInitializeCommands("Unable to get stream from resource " + resourceName);
            }
            Object unmarshalledObject = unmarshaller.unmarshal(ClassLoader.getSystemResourceAsStream(resourceName));
            if (unmarshalledObject instanceof JAXBElement) {
                JAXBElement commandSetElement = (JAXBElement)unmarshalledObject;
                TContext context = (TContext)commandSetElement.getValue();
                ActionLoader.processContext(actionLogicMgr, context);
            }
        }
        catch (Throwable e) {
            DBMTLogger.info(Channel.DEV, "Error loading action xml file: " + resourceName, e);
            DBMTLogger.error(Channel.USER, StringLocalizer.get("", new String[]{resourceName}), e);
            e.printStackTrace();
        }
        return actionLogicMgr;
    }

    public static Object extractObject(Serializable jaxbElement, Class<?> cls) {
        JAXBElement elem;
        Object value;
        if (jaxbElement instanceof JAXBElement && cls.isInstance(value = (elem = (JAXBElement)jaxbElement).getValue())) {
            return value;
        }
        return null;
    }

    private static void processContext(ActionLogicManager actionLogicMgr, TContext context) throws Exception {
        List<Serializable> content = context.getContent();
        for (Serializable o : content) {
            TImport importFile = (TImport)ActionLoader.extractObject(o, TImport.class);
            TActionSet actionSet = (TActionSet)ActionLoader.extractObject(o, TActionSet.class);
            if (importFile != null) {
                HashMap<String, Map<String, ValueDef>> templates = new HashMap<String, Map<String, ValueDef>>();
                ActionLoader.processImportFile(templates, importFile.getLocation());
                for (Map.Entry entry : templates.entrySet()) {
                    actionLogicMgr.addTemplate((String)entry.getKey(), (Map)entry.getValue());
                }
            }
            if (actionSet == null) continue;
            ActionLogicManagerImpl.inst().getRoot().addNode(actionSet.getId());
            ActionLoader.processActionSet(actionLogicMgr, actionSet, context.getType(), actionSet.getId());
        }
    }

    private static String getContextName(String context) throws Exception {
        return Class.forName(context).getSimpleName();
    }

    private static void processActionSet(ActionLogicManager actionLogicMgr, TActionSet actionSet, String contextClass, String actionSetPath) throws Exception {
        String resourcePrefix = "action." + ActionLoader.getContextName(contextClass);
        List<Serializable> subActions = actionSet.getContent();
        for (Serializable o : subActions) {
            TAction action = (TAction)ActionLoader.extractObject(o, TAction.class);
            TActionSet subActionSet = (TActionSet)ActionLoader.extractObject(o, TActionSet.class);
            if (action != null) {
                try {
                    String actionPath = actionSetPath + "." + action.getId();
                    WizardFactory wizardFactory = ActionLoader.createWizardFactory(subActionSet, actionLogicMgr, action, resourcePrefix + "." + actionSetPath);
                    ActionLogicTreeNode node = actionLogicMgr.findActionNode("/" + actionSetPath.replace('.', '/'));
                    if (wizardFactory != null) {
                        ActionOperation actionOp = ActionLoader.createWizard(wizardFactory, action.getContext(), resourcePrefix, action.getClazz(), actionPath);
                        node.addActionLogic(action.getId(), actionOp);
                    }
                }
                catch (Throwable e) {
                    DBMTLogger.warn(Channel.USER, StringLocalizer.get("", new String[]{resourcePrefix, action.getId()}));
                    e.printStackTrace();
                }
            }
            if (subActionSet == null) continue;
            actionLogicMgr.findActionNode(actionSetPath).addNode(actionSet.getId());
            ActionLoader.processActionSet(actionLogicMgr, subActionSet, resourcePrefix + "." + subActionSet.getId(), actionSetPath + "." + subActionSet.getId());
        }
    }

    private static WizardFactory createWizardFactory(TActionSet subActionSet, ActionLogicManager actionLogicMgr, TAction action, String resourcePrefix) throws Exception {
        TWizard wizard = null;
        for (Serializable s : action.getContent()) {
            TWizard newWizard = (TWizard)ActionLoader.extractObject(s, TWizard.class);
            if (newWizard == null) continue;
            if (wizard != null && newWizard != null) {
                throw new Exception("Wizard Node already set");
            }
            wizard = newWizard;
        }
        if (wizard == null) {
            return null;
        }
        String baseResourceId = resourcePrefix + "." + action.getId() + ".wiz";
        return new WizardFactory(ActionLoader.processWizard(actionLogicMgr, wizard, baseResourceId));
    }

    private static WizardInteractorDataDef processWizard(ActionLogicManager actionLogicMgr, TWizard wizard, String baseResourceId) throws Exception {
        WizardInteractorDataDef wizardDataDef = new WizardInteractorDataDef(baseResourceId + ".name", baseResourceId + ".desc");
        for (Serializable s : wizard.getContent()) {
            TPage page = (TPage)ActionLoader.extractObject(s, TPage.class);
            TCommitPage commitPage = (TCommitPage)ActionLoader.extractObject(s, TCommitPage.class);
            if (page != null) {
                InteractorDataDef dataDef = new InteractorDataDef(baseResourceId + ".page." + page.getId());
                ActionLoader.processPage(page, actionLogicMgr, dataDef, wizardDataDef, baseResourceId);
            }
            if (commitPage == null) continue;
            ActionLoader.processCommitPage(baseResourceId, wizardDataDef, commitPage);
        }
        String startPage = wizard.getStart();
        wizardDataDef.setStart(startPage);
        return wizardDataDef;
    }

    private static void processCommitPage(String baseResourceId, WizardInteractorDataDef wizardDataDef, TCommitPage commitPage) throws Exception {
        wizardDataDef.getDataDefMap().put(commitPage.getId(), new CommitPageDataDef(commitPage.getId(), baseResourceId, baseResourceId + ".name", baseResourceId + ".name"));
        wizardDataDef.getForwardDependencies(commitPage.getId()).add("commit-status");
        wizardDataDef.addCommitPage(commitPage.getId());
        if (commitPage.isFinish()) {
            wizardDataDef.addFinishablePage(commitPage.getId());
        }
        for (Serializable s : commitPage.getContent()) {
            TForward forward = (TForward)ActionLoader.extractObject(s, TForward.class);
            if (forward == null) continue;
            ActionLoader.processForward(commitPage.getId(), wizardDataDef, forward);
        }
        wizardDataDef.getForwardValidators(commitPage.getId()).add(new FieldTester(new TestOp(){

            @Override
            public boolean validate(Object context, InteractorData data, List<String> fieldIds, List<String> params) throws InteractorDataError {
                boolean isFinished = data.getValue("commit-status").equals(CommitPageDataDef.CommitStatus.FINISHED.toString());
                return isFinished;
            }

            @Override
            public String[] reasonParams(InteractorData data, List<String> fieldIds, List<String> params) throws InvalidDialogField {
                return new String[0];
            }
        }, new ArrayList<String>(), new ArrayList<String>(), null));
    }

    private static ActionOperation createWizard(WizardFactory factory, String contextClass, String baseResourceId, String actionClassName, String actionPath) {
        ActionOperation actionOp = null;
        String resourceId = baseResourceId + "." + actionPath;
        try {
            actionOp = factory.createAction(actionClassName, contextClass, "/" + actionPath.replace('.', '/'), resourceId + ".name", resourceId + ".desc");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            DBMTLogger.error(Channel.USER, StringLocalizer.get("dbmt.action.error.classnotfound", new String[]{actionClassName, actionPath}));
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            DBMTLogger.error(Channel.USER, StringLocalizer.get("dbmt.action.error.cantinstantiate", new String[]{actionClassName, actionPath}));
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            DBMTLogger.error(Channel.USER, StringLocalizer.get("dbmt.action.error.illegalaccess", new String[]{actionClassName, actionPath}));
            e.printStackTrace();
        }
        catch (SecurityException e) {
            DBMTLogger.error(Channel.USER, StringLocalizer.get("dbmt.action.error.securityexception", new String[]{actionClassName, actionPath}));
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            DBMTLogger.error(Channel.USER, StringLocalizer.get("dbmt.action.error.nosuchmethodexception", new String[]{actionClassName, actionPath}));
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            DBMTLogger.error(Channel.USER, StringLocalizer.get("dbmt.action.error.illegalargument", new String[]{actionClassName, actionPath}));
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            DBMTLogger.error(Channel.USER, StringLocalizer.get("dbmt.action.error.invocationexception", new String[]{actionClassName, actionPath}));
            e.printStackTrace();
        }
        return actionOp;
    }

    private static void processPage(TPage page, ActionLogicManager actionLogicMgr, InteractorDataDef pageDataDef, WizardInteractorDataDef wizardDataDef, String wizardResourceRoot) throws Exception {
        String pageResourceRoot = wizardResourceRoot + ".page." + page.getId();
        boolean back = page.isBack();
        boolean cancel = page.isCancel();
        for (Serializable s : page.getContent()) {
            TTemplateReference templateReference = (TTemplateReference)ActionLoader.extractObject(s, TTemplateReference.class);
            TStringField stringField = (TStringField)ActionLoader.extractObject(s, TStringField.class);
            TBoolField booleanField = (TBoolField)ActionLoader.extractObject(s, TBoolField.class);
            TIntField integerField = (TIntField)ActionLoader.extractObject(s, TIntField.class);
            TEnumField enumField = (TEnumField)ActionLoader.extractObject(s, TEnumField.class);
            TFileField fileField = (TFileField)ActionLoader.extractObject(s, TFileField.class);
            TTextField textField = (TTextField)ActionLoader.extractObject(s, TTextField.class);
            TForward forward = (TForward)ActionLoader.extractObject(s, TForward.class);
            TFinish finish = (TFinish)ActionLoader.extractObject(s, TFinish.class);
            if (templateReference != null) {
                ActionLoader.processTemplateReference(pageResourceRoot, templateReference, actionLogicMgr, pageDataDef);
            }
            if (stringField != null) {
                if (((JAXBElement)s).getName().getLocalPart().equals(ELEM_NAME_STRING)) {
                    pageDataDef.addValueDef(stringField.getId(), new ValueDef(pageResourceRoot, "fld", stringField.getId(), new StringTypeDef(stringField.getMask()), stringField.getDefault()));
                } else {
                    pageDataDef.addValueDef(stringField.getId(), new ValueDef(pageResourceRoot, "fld", stringField.getId(), PasswordTypeDef.inst(), stringField.getDefault()));
                }
                ActionLoader.processFieldTests(stringField.getContent(), pageDataDef, stringField.getId());
            }
            if (booleanField != null) {
                pageDataDef.addValueDef(booleanField.getId(), new ValueDef(pageResourceRoot, "fld", booleanField.getId(), BooleanTypeDef.inst(), Boolean.toString(booleanField.isDefault()).toString()));
                ActionLoader.processFieldTests(booleanField.getContent(), pageDataDef, booleanField.getId());
            }
            if (integerField != null) {
                pageDataDef.addValueDef(integerField.getId(), new ValueDef(pageResourceRoot, "fld", integerField.getId(), IntegerTypeDef.inst(), integerField.getDefault().toString()));
                ActionLoader.processFieldTests(integerField.getContent(), pageDataDef, integerField.getId());
            }
            if (enumField != null) {
                EnumDataEntry[] values = ActionLoader.getEnumValues(enumField, pageResourceRoot + ".fld." + enumField.getId());
                if (((JAXBElement)s).getName().getLocalPart().equals(ELEM_NAME_SELECT)) {
                    HashSet<EnumDataEntry> selectValues = new HashSet<EnumDataEntry>();
                    for (EnumDataEntry ede : values) {
                        selectValues.add(ede);
                    }
                    pageDataDef.addValueDef(enumField.getId(), new ValueDef(pageResourceRoot, "fld", enumField.getId(), SelectTypeDef.create(selectValues), enumField.getDefault()));
                } else {
                    pageDataDef.addValueDef(enumField.getId(), new ValueDef(pageResourceRoot, "fld", enumField.getId(), EnumTypeDef.create(values), enumField.getDefault()));
                }
                ActionLoader.processFieldTests(enumField.getContent(), pageDataDef, enumField.getId());
            }
            if (fileField != null) {
                pageDataDef.addValueDef(fileField.getId(), new ValueDef(pageResourceRoot, "fld", fileField.getId(), new FileTypeDef(FileTypeDef.SelectableObject.valueOf(fileField.getSelect().value().toUpperCase())), ""));
                ActionLoader.processFieldTests(fileField.getContent(), pageDataDef, fileField.getId());
            }
            if (textField != null) {
                pageDataDef.addText(textField.getId(), ActionLoader.getTextFieldValue(pageResourceRoot, textField));
            }
            if (forward != null) {
                ActionLoader.processForward(page.getId(), wizardDataDef, forward);
            }
            if (finish == null) continue;
            wizardDataDef.addFinishablePage(page.getId());
            for (Serializable s1 : finish.getContent()) {
                TTest test = (TTest)ActionLoader.extractObject(s1, TTest.class);
                if (test == null) continue;
                ActionLoader.processFinishValidator(test, pageDataDef);
            }
        }
        wizardDataDef.getDataDefMap().put(page.getId(), pageDataDef);
        if (back) {
            wizardDataDef.addPreviousPage(page.getId());
        }
        pageDataDef.setCancel(cancel);
        wizardDataDef.setPageNext(page.getId(), WizardNavigationAction.valueOf(page.getNext().value().toUpperCase()));
    }

    private static void processFieldTests(List<Serializable> content, InteractorDataDef dataDef, String fieldId) throws Exception {
        for (Serializable s : content) {
            TTestSet testSet = (TTestSet)ActionLoader.extractObject(s, TTestSet.class);
            if (testSet == null) continue;
            for (Serializable t : testSet.getContent()) {
                TTest test = (TTest)ActionLoader.extractObject(t, TTest.class);
                if (test == null) continue;
                ArrayList<String> fields = new ArrayList<String>();
                ArrayList<String> params = new ArrayList<String>();
                for (TTestField field : test.getField()) {
                    fields.add(field.getId());
                }
                for (TTestParam param : test.getParam()) {
                    params.add(param.getValue());
                }
                TestOp testOp = ActionLoader.createTestOp(test.getClazz());
                Collection<FieldTester> tests = dataDef.getValidatorMap().get(fieldId);
                if (tests == null) {
                    tests = new HashSet<FieldTester>();
                    dataDef.getValidatorMap().put(fieldId, tests);
                }
                tests.add(new FieldTester(testOp, fields, params, null));
            }
        }
    }

    private static void processForward(String pageId, WizardInteractorDataDef wizardDataDef, TForward forward) throws Exception {
        ForwardLogic forwardLogic = ActionLoader.processForwardLogic(pageId, forward.getContent());
        for (Serializable s : forward.getContent()) {
            TTest test = (TTest)ActionLoader.extractObject(s, TTest.class);
            if (test == null) continue;
            ActionLoader.processPageValidator(test, wizardDataDef, pageId);
        }
        wizardDataDef.getForwardMap().put(pageId, forwardLogic.createNextOp());
    }

    private static void processPageValidator(TTest test, WizardInteractorDataDef wizardDataDef, String pageId) throws Exception {
        ArrayList<String> fields = new ArrayList<String>();
        ArrayList<String> params = new ArrayList<String>();
        String testClassName = test.getClazz();
        for (TTestField field : test.getField()) {
            fields.add(field.getId());
        }
        for (TTestParam param : test.getParam()) {
            params.add(param.getValue());
        }
        TestOp testOp = ActionLoader.createTestOp(testClassName);
        FieldTester tester = new FieldTester(testOp, fields, params, null);
        wizardDataDef.getForwardValidators(pageId).add(tester);
    }

    private static void processFinishValidator(TTest test, InteractorDataDef pageDataDef) throws Exception {
        ArrayList<String> fields = new ArrayList<String>();
        ArrayList<String> params = new ArrayList<String>();
        String testClassName = test.getClazz();
        for (TTestField field : test.getField()) {
            fields.add(field.getId());
        }
        for (TTestParam param : test.getParam()) {
            params.add(param.getValue());
        }
        TestOp testOp = ActionLoader.createTestOp(testClassName);
        FieldTester tester = new FieldTester(testOp, fields, params, null);
        pageDataDef.addFinishValidator(tester);
    }

    private static TestOp createTestOp(String testClassName) throws Exception {
        Class<?> testClass = Class.forName(testClassName);
        Object testOpObject = testClass.newInstance();
        if (testOpObject instanceof TestOp) {
            return (TestOp)testOpObject;
        }
        throw new Exception("The class " + testClass.getSimpleName() + " in package " + testClass.getPackage().getName() + " is not an instance of " + TestOp.class.getName());
    }

    private static ForwardLogic processForwardLogic(String pageId, List<Serializable> content) {
        if (content.size() == 0) {
            return null;
        }
        for (int i = 0; i < content.size(); ++i) {
            if (!(content.get(i) instanceof JAXBElement)) continue;
            return ActionLoader.createForwardLogic(pageId, content.get(i));
        }
        return null;
    }

    private static ForwardLogic createForwardLogic(String pageId, Serializable s) {
        TStatic staticForward = (TStatic)ActionLoader.extractObject(s, TStatic.class);
        TSwitch switchForward = (TSwitch)ActionLoader.extractObject(s, TSwitch.class);
        if (staticForward != null) {
            return new StaticForward(staticForward.getPage());
        }
        if (switchForward != null) {
            return ActionLoader.processSwitch(pageId, switchForward);
        }
        return null;
    }

    private static ForwardLogic processSwitch(String pageId, TSwitch switchForwardNode) {
        SwitchForward switchForward = new SwitchForward(pageId, switchForwardNode.getField());
        for (Serializable s : switchForwardNode.getContent()) {
            if (!(s instanceof JAXBElement)) continue;
            TCase caseNode = (TCase)ActionLoader.extractObject(s, TCase.class);
            switchForward.addCase(caseNode.getValue(), ActionLoader.processForwardLogic(pageId, caseNode.getContent()));
        }
        return switchForward;
    }

    private static TextDefinition getTextFieldValue(String pageResourceRoot, TTextField textField) {
        ArrayList<String> keys = new ArrayList<String>();
        for (Serializable s : textField.getContent()) {
            if (!(s instanceof TTextSubstitution)) continue;
            TTextSubstitution subst = (TTextSubstitution)((Object)s);
            keys.add(subst.getKey());
        }
        return new TextDefinition(pageResourceRoot + ".txt." + textField.getId(), keys);
    }

    private static EnumDataEntry[] getEnumValues(TEnumField enumField, String pageResourceRoot) {
        ArrayList<EnumDataEntry> values = new ArrayList<EnumDataEntry>();
        for (Serializable s : enumField.getContent()) {
            TEnumValue value;
            if (!(s instanceof JAXBElement) || (value = (TEnumValue)ActionLoader.extractObject(s, TEnumValue.class)) == null) continue;
            String id = value.getId();
            String title = pageResourceRoot + ".value." + value.getId() + ".name";
            String desc = pageResourceRoot + ".value." + value.getId() + ".desc";
            String mnemonic = pageResourceRoot + ".value." + value.getId() + ".mnemonic";
            values.add(new EnumDataEntry(id, title, desc, mnemonic));
        }
        return values.toArray(new EnumDataEntry[0]);
    }

    private static void processTemplateReference(String pageResourceRoot, TTemplateReference templateReference, ActionLogicManager actionLogicMgr, InteractorDataDef dataDef) {
        Map<String, ValueDef> template = actionLogicMgr.getTemplate(templateReference.getId());
        if (template == null) {
            DBMTLogger.error(Channel.DEV, "Could not find referenced template " + templateReference.getId());
            return;
        }
        Map<String, Map<String, String>> fieldMap = ActionLoader.processTemplateRemapping(templateReference, actionLogicMgr);
        for (Map.Entry<String, ValueDef> field : template.entrySet()) {
            TypeDef fieldTypeDef;
            String value = null;
            Map<String, String> remapMap = fieldMap.get(field.getKey());
            if (remapMap != null) {
                value = remapMap.get("DEFAULT");
            }
            if (value == null) {
                value = field.getValue().getDefaultValue();
            }
            if ((fieldTypeDef = field.getValue().getTypeDef()).getValueClass() == EnumTypeDef.getEnumClass()) {
                EnumTypeDef eTypeDef = (EnumTypeDef)fieldTypeDef;
                EnumDataEntry[] templData = eTypeDef.getValues();
                EnumDataEntry[] data = new EnumDataEntry[templData.length];
                for (int i = 0; i < data.length; ++i) {
                    String id = templData[i].getId();
                    data[i] = new EnumDataEntry(id, pageResourceRoot + ".fld." + field.getKey() + ".value." + id + ".name", pageResourceRoot + ".fld." + field.getKey() + ".value." + id + ".desc", pageResourceRoot + ".fld." + field.getKey() + ".value." + id + ".mnemonic");
                }
                ValueDef valueDef = new ValueDef(pageResourceRoot, "fld", field.getKey(), EnumTypeDef.create(data), value);
                dataDef.addValueDef(field.getKey(), valueDef);
                continue;
            }
            ValueDef valueDef = new ValueDef(pageResourceRoot, "fld", field.getKey(), fieldTypeDef, value);
            dataDef.addValueDef(field.getKey(), valueDef);
        }
    }

    private static Map<String, Map<String, String>> processTemplateRemapping(TTemplateReference templateReference, ActionLogicManager actionLogicMgr) {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        for (TRemapField field : templateReference.getRemap()) {
            HashMap<String, String> subMap = new HashMap<String, String>();
            for (TRemapValue value : field.getValue()) {
                subMap.put(value.getId().toString(), value.getValue());
            }
            map.put(field.getId(), subMap);
        }
        return map;
    }

    private static void processImportFile(Map<String, Map<String, ValueDef>> templates, String location) throws Exception {
        InputStream input = ClassLoader.getSystemResourceAsStream(location);
        if (input == null) {
            throw new Exception("Unable to find import resource " + location);
        }
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        parser.parse(input, (DefaultHandler)new ImportTemplateProcessorHander(templates));
    }

    private static class ImportTemplateProcessorHander
    extends DefaultHandler {
        private static final Set<String> s_fieldTypes = ImportTemplateProcessorHander.createAndInitializeFieldTypes();
        public final Map<String, Map<String, ValueDef>> m_templates;
        public String m_templateName = null;
        public Map<String, ValueDef> m_templateBody = null;
        public List<EnumDataEntry> m_enumValues = null;
        public String enumId;

        public ImportTemplateProcessorHander(Map<String, Map<String, ValueDef>> templates) {
            this.m_templates = templates;
        }

        private static Set<String> createAndInitializeFieldTypes() {
            HashSet<String> fieldTypes = new HashSet<String>();
            fieldTypes.add(ActionLoader.ELEM_NAME_STRING);
            fieldTypes.add(ActionLoader.ELEM_NAME_PASSWORD);
            fieldTypes.add(ActionLoader.ELEM_NAME_SELECT);
            fieldTypes.add(ActionLoader.ELEM_NAME_BOOL);
            fieldTypes.add(ActionLoader.ELEM_NAME_ENUM);
            fieldTypes.add(ActionLoader.ELEM_NAME_ENUMVALUE);
            return fieldTypes;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String name, Attributes atts) throws SAXException {
            if (name.equals(ActionLoader.ELEM_NAME_TEMPLATE)) {
                this.m_templateName = atts.getValue(ActionLoader.ATTR_NAME_ID);
                this.m_templateBody = new HashMap<String, ValueDef>();
                return;
            }
            if (s_fieldTypes.contains(name)) {
                if (this.m_templateBody == null) {
                    throw new SAXException("Unexpected element " + name + " outside of template");
                }
                String id = atts.getValue(ActionLoader.ATTR_NAME_ID);
                String defValue = atts.getValue("default");
                try {
                    if (name.equals(ActionLoader.ELEM_NAME_STRING)) {
                        this.m_templateBody.put(id, new ValueDef("", "fld", id, new StringTypeDef(atts.getValue("mask")), defValue));
                    } else if (name.equals(ActionLoader.ELEM_NAME_PASSWORD)) {
                        this.m_templateBody.put(id, new ValueDef("", "fld", id, PasswordTypeDef.inst(), defValue));
                    } else if (name.equals(ActionLoader.ELEM_NAME_SELECT)) {
                        SelectTypeDef selectTd = SelectTypeDef.create(emptySelectValues);
                        this.m_templateBody.put(id, new ValueDef("", "fld", id, selectTd, defValue));
                    } else if (name.equals(ActionLoader.ELEM_NAME_BOOL)) {
                        this.m_templateBody.put(id, new ValueDef("", "fld", id, BooleanTypeDef.inst(), defValue));
                    } else if (name.equals(ActionLoader.ELEM_NAME_ENUM)) {
                        this.m_enumValues = new ArrayList<EnumDataEntry>();
                        this.enumId = atts.getValue(ActionLoader.ATTR_NAME_ID);
                    } else if (name.equals(ActionLoader.ELEM_NAME_ENUMVALUE)) {
                        this.m_enumValues.add(new EnumDataEntry(atts.getValue(ActionLoader.ATTR_NAME_ID), null, null, null));
                    }
                }
                catch (Exception e) {
                    throw new SAXException(e);
                }
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String name) throws SAXException {
            if (name.equals(ActionLoader.ELEM_NAME_TEMPLATE)) {
                this.m_templates.put(this.m_templateName, this.m_templateBody);
                this.m_templateName = null;
                this.m_templateBody = null;
            } else if (name.equals(ActionLoader.ELEM_NAME_ENUM)) {
                this.m_templateBody.put(this.enumId, new ValueDef("", "fld", this.enumId, EnumTypeDef.create(this.m_enumValues.toArray(new EnumDataEntry[this.m_enumValues.size()])), this.m_enumValues.get(0).getId()));
                this.m_enumValues = null;
                this.enumId = null;
            }
        }
    }
}

