/*
 * Decompiled with CFR 0.152.
 */
package fixtures.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ValidateSchemaObjects {
    private Document dom;
    private String m_tagname;
    private String value;
    private StringTokenizer stk;
    private String prev = "";
    private String curr = "";

    public void parseSchemaFile(String xmlfile) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.dom = db.parse(xmlfile);
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void parseDocument(String tagname, String target, List<String> myObjects) {
        Element docEle = this.dom.getDocumentElement();
        NodeList nl = docEle.getElementsByTagName(tagname);
        if ("PrimaveraDatabaseSchema".equals(tagname)) {
            myObjects.add(docEle.getAttribute("DBTYPE") + "," + docEle.getAttribute("VERSION"));
            return;
        }
        if (nl != null && nl.getLength() > 0) {
            block0: for (int i = 0; i < nl.getLength(); ++i) {
                Element el = (Element)nl.item(i);
                this.value = null;
                if (!el.hasAttribute("TARGET")) {
                    myObjects.add(this.getattribval(el).toString().toUpperCase());
                    continue;
                }
                this.value = el.getAttribute("TARGET");
                this.stk = null;
                this.stk = new StringTokenizer(this.value, ",");
                while (this.stk.hasMoreTokens()) {
                    String test = this.stk.nextToken();
                    if (!test.equals(target)) continue;
                    myObjects.add(this.getattribval(el).toString().toUpperCase());
                    continue block0;
                }
            }
        }
    }

    public void parseDocFields(Map<String, List<String>> docFields) {
        String m_tagname = "FIELD";
        Element docEle = this.dom.getDocumentElement();
        NodeList nl = docEle.getElementsByTagName(m_tagname);
        ArrayList<String> columns = null;
        if (nl != null && nl.getLength() > 0) {
            for (int i = 0; i < nl.getLength(); ++i) {
                Element el = (Element)nl.item(i);
                this.value = null;
                this.curr = el.getAttribute("TABLE");
                if ("".equals(this.prev)) {
                    this.prev = this.curr;
                    columns = new ArrayList<String>();
                }
                if (columns != null && this.prev.equals(this.curr)) {
                    columns.add(this.getattribval(el).toString().toUpperCase());
                    continue;
                }
                docFields.put(this.prev.toUpperCase(), columns);
                columns = new ArrayList();
                columns.add(this.getattribval(el).toString().toUpperCase());
                this.prev = this.curr;
            }
            docFields.put(this.prev.toUpperCase(), columns);
        }
    }

    public Map<String, List<String>> parseGrants() {
        HashMap<String, List<String>> myMap = new HashMap<String, List<String>>();
        ArrayList<String> grantslist = new ArrayList<String>();
        Element docEle = this.dom.getDocumentElement();
        this.m_tagname = "TABLE";
        NodeList nl = docEle.getElementsByTagName(this.m_tagname);
        grantslist.add("SELECT");
        grantslist.add("INSERT");
        grantslist.add("UPDATE");
        grantslist.add("DELETE");
        if (nl != null && nl.getLength() > 0) {
            for (int i = 0; i < nl.getLength(); ++i) {
                Element el = (Element)nl.item(i);
                this.value = null;
                myMap.put(this.getattribval(el).toString(), new ArrayList(grantslist));
            }
        }
        return myMap;
    }

    public Object getattribval(Element el) {
        String name = el.getAttribute("NAME");
        return name;
    }
}

