/*
 * Decompiled with CFR 0.152.
 */
package fixtures.util;

import com.primavera.database.common.DatabaseHelper;
import com.primavera.database.common.ServerType;
import fit.ActionFixture;
import fixtures.util.DatabaseConnFixture;
import fixtures.util.ValidateSchemaObjects;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class SchemaTestFixture
extends ActionFixture {
    private static String dbobject = "";
    private static ValidateSchemaObjects vso;
    private static ArrayList<String> li;
    private static Connection connection;
    private static String username;
    private static String[] names;
    private static List<String> myObjects;
    private static String dbtarget;
    private static ServerType st;
    private static String dbliobject;
    private static StringTokenizer stk;
    private static String sqlstring;
    private static Statement s;
    private static HashMap<String, List<String>> tabcolumns;
    private static HashMap<String, List<String>> dbcolumns;
    private static final String SS_INDEXES_QUERY = "select name from sys.indexes where name is not NULL ";
    private static final String SS_TRIGGERS_QUERY = "select name from sys.triggers where name is not NULL ";
    private static final String SS_CONSTRAINTS_QUERY = "select constraint_name from information_schema.table_constraints";
    private static final String OR_VIEWS_QUERY = "select view_name from user_views";
    private static final String OR_SYNONYMS_QUERY = "select synonym_name from user_synonyms";
    private static final String SS_VIEWS_QUERY = "select table_name from information_schema.views";
    private static final String OR_GRANTS_QUERY = "select grantee,table_name,grantor,privilege from user_tab_privs order by table_name";
    private static final String SS_GRANTS_QUERY = "select table_name,privilege_type from information_schema.table_privileges";
    private static final String OR_CONSTRAINTS_QUERY = "select constraint_name from user_constraints";
    private static final String OR_LICENSE_QUERY = "select dbms_lob.getlength(license_data) from prefer";
    private static final String OR_NEXTKEYS_QUERY = "select substr(key_name,1,instr(key_name,'_')-1) table_name,substr(key_name,instr(key_name,'_')+1,length(key_name))pkcol,key_name,key_seq_num from nextkey";
    private static final String SS_LICENSE_QUERY = "select datalength(license_data) from prefer";
    private Map<String, List<String>> tabgrants = new HashMap<String, List<String>>();
    private final Map<String, List<String>> dbgrants = new HashMap<String, List<String>>();
    private String m_batchfile;
    private long m_delay;

    public static void setXMLfile(String xmlfile) {
        vso = new ValidateSchemaObjects();
        vso.parseSchemaFile(xmlfile);
    }

    public void execBatch() throws Exception {
        System.out.println("Running the batch script");
        Runtime.getRuntime().exec(this.m_batchfile);
        System.out.println("Finished running the batch script");
    }

    public static void parse() throws Exception {
        SchemaTestFixture.setDbTarget();
        li = new ArrayList();
        for (int i = 0; i < 10; ++i) {
            if (names[i].equals("")) continue;
            vso.parseDocument(names[i], dbtarget, li);
        }
    }

    public static void setDbTarget() throws Exception {
        connection = DatabaseConnFixture.getconnection();
        st = DatabaseHelper.getServerType((Connection)connection);
        dbtarget = st == ServerType.ORACLE ? "OR" : (st == ServerType.SQLSERVER ? "SS" : "ASA");
    }

    public static void parseFields() throws Exception {
        SchemaTestFixture.setDbTarget();
        tabcolumns.clear();
        vso.parseDocFields(tabcolumns);
    }

    public void parseGrants() throws Exception {
        SchemaTestFixture.setDbTarget();
        this.tabgrants.clear();
        this.tabgrants = vso.parseGrants();
    }

    public static String printTabColumns(Map<String, List<String>> h, String type) {
        Set<String> hashMapSet = h.keySet();
        Iterator<String> iter = hashMapSet.iterator();
        dbliobject = "";
        int hash = 0;
        int col = 0;
        while (iter.hasNext()) {
            ++hash;
            String table = iter.next();
            List<String> colList = h.get(table);
            ListIterator<String> colIter = colList.listIterator();
            dbliobject = dbliobject + table + ":";
            while (colIter.hasNext()) {
                dbliobject = dbliobject + (String)colIter.next();
                ++col;
                if (!colIter.hasNext()) continue;
                dbliobject = dbliobject + ",";
            }
            colList = null;
            colIter = null;
            dbliobject = dbliobject + "   ";
        }
        if (type.compareTo("Column") == 0) {
            return "Missing columns(TABLE:COLUMNS)" + dbliobject;
        }
        return "Missing grants(TABLE:GRANTS)" + dbliobject;
    }

    public static void listtostr() {
        dbliobject = "";
        for (String str : li) {
            if (dbliobject == "") {
                dbliobject = str;
                continue;
            }
            dbliobject = dbliobject + "," + str;
        }
    }

    public static void setUserName(String user) {
        username = user.toUpperCase();
    }

    public static void setObjectType(String objtype) {
        int i = 0;
        for (i = 0; i < 10; ++i) {
            SchemaTestFixture.names[i] = "";
        }
        i = 0;
        stk = new StringTokenizer(objtype, ",");
        while (stk.hasMoreTokens()) {
            SchemaTestFixture.names[i] = new String(stk.nextToken());
            ++i;
        }
    }

    public static void getObjects() throws Exception {
        ResultSet rs = connection.getMetaData().getTables(null, username, "%", names);
        dbobject = "";
        myObjects.clear();
        while (rs.next()) {
            dbobject = dbobject + ";" + rs.getString(3);
            myObjects.add(rs.getString(3));
        }
        rs.close();
    }

    public static void getssIndexes() throws Exception {
        s = connection.createStatement();
        ResultSet rs = s.executeQuery(SS_INDEXES_QUERY);
        dbobject = "";
        myObjects.clear();
        while (rs.next()) {
            dbobject = dbobject + ";" + rs.getString("name");
            myObjects.add(rs.getString("name").toUpperCase());
        }
        rs.close();
    }

    public static void getssTriggers() throws Exception {
        s = connection.createStatement();
        ResultSet rs = s.executeQuery(SS_TRIGGERS_QUERY);
        dbobject = "";
        myObjects.clear();
        while (rs.next()) {
            dbobject = dbobject + ";" + rs.getString("name");
            myObjects.add(rs.getString("name").toUpperCase());
        }
        rs.close();
    }

    public static void getssConstraints() throws Exception {
        s = connection.createStatement();
        ResultSet rs = s.executeQuery(SS_CONSTRAINTS_QUERY);
        dbobject = "";
        myObjects.clear();
        while (rs.next()) {
            dbobject = dbobject + ";" + rs.getString("constraint_name");
            myObjects.add(rs.getString("constraint_name").toUpperCase());
        }
        rs.close();
    }

    public static String validateSSIsolation() throws Exception {
        SchemaTestFixture.setDbTarget();
        s = connection.createStatement();
        String isolevel = "123";
        ResultSet rs = s.executeQuery("DBCC USEROPTIONS");
        while (rs.next()) {
            if (!rs.getString(1).equals("isolation level")) continue;
            isolevel = rs.getString(2);
        }
        if ("read committed snapshot".equals(isolevel)) {
            return "Pass";
        }
        return "current isolation level :" + isolevel + " Expected:read committed snapshot";
    }

    public static void getorViews() throws Exception {
        dbobject = "";
        myObjects.clear();
        s = connection.createStatement();
        ResultSet rs = s.executeQuery(OR_VIEWS_QUERY);
        while (rs.next()) {
            dbobject = dbobject + ";" + rs.getString("view_name");
            myObjects.add(rs.getString("view_name").toUpperCase());
        }
        rs.close();
        rs = s.executeQuery(OR_SYNONYMS_QUERY);
        while (rs.next()) {
            dbobject = dbobject + ";" + rs.getString("synonym_name");
            myObjects.add(rs.getString("synonym_name").toUpperCase());
        }
        rs.close();
    }

    public static void getssViews() throws Exception {
        dbobject = "";
        myObjects.clear();
        s = connection.createStatement();
        ResultSet rs = s.executeQuery(SS_VIEWS_QUERY);
        while (rs.next()) {
            dbobject = dbobject + ";" + rs.getString("table_name");
            myObjects.add(rs.getString("table_name").toUpperCase());
        }
        rs.close();
    }

    public static void getorConstraints() throws Exception {
        dbobject = "";
        myObjects.clear();
        s = connection.createStatement();
        ResultSet rs = s.executeQuery(OR_CONSTRAINTS_QUERY);
        while (rs.next()) {
            dbobject = dbobject + ";" + rs.getString("constraint_name");
            myObjects.add(rs.getString("constraint_name").toUpperCase());
        }
        rs.close();
    }

    public static void getorProcedures() throws Exception {
        dbobject = "";
        myObjects.clear();
        s = connection.createStatement();
        sqlstring = "select object_name from user_objects where object_type in ('PROCEDURE','FUNCTION','PACKAGE')";
        ResultSet rs = s.executeQuery(sqlstring);
        while (rs.next()) {
            dbobject = dbobject + ";" + rs.getString("object_name");
            myObjects.add(rs.getString("object_name").toUpperCase());
        }
        rs.close();
    }

    public static void getssProcedures() throws Exception {
        dbobject = "";
        myObjects.clear();
        s = connection.createStatement();
        sqlstring = "select name from sys.objects where type in ('P','FN','TF')";
        ResultSet rs = s.executeQuery(sqlstring);
        while (rs.next()) {
            dbobject = dbobject + ";" + rs.getString("name");
            myObjects.add(rs.getString("name").toUpperCase());
        }
        rs.close();
    }

    public void getGrants() throws Exception {
        String prev = "";
        String curr = "";
        SchemaTestFixture.setDbTarget();
        ArrayList<String> columns = null;
        dbobject = "";
        myObjects.clear();
        s = connection.createStatement();
        ResultSet rs = null;
        if (dbtarget == "OR") {
            rs = s.executeQuery(OR_GRANTS_QUERY);
        } else if (dbtarget == "SS") {
            rs = s.executeQuery(SS_GRANTS_QUERY);
        } else {
            throw new SQLException("Invalid database target: " + dbtarget);
        }
        while (rs.next()) {
            curr = rs.getString("table_name");
            if ("".equals(prev)) {
                prev = curr;
                columns = new ArrayList<String>();
            }
            if (columns != null && prev.equals(curr)) {
                if (dbtarget == "OR") {
                    columns.add(rs.getString("privilege").toUpperCase());
                    continue;
                }
                columns.add(rs.getString("privilege_type").toUpperCase());
                continue;
            }
            this.dbgrants.put(prev.toUpperCase(), columns);
            columns = new ArrayList();
            if (dbtarget == "OR") {
                columns.add(rs.getString("privilege").toUpperCase());
            } else {
                columns.add(rs.getString("privilege_type").toUpperCase());
            }
            prev = curr;
        }
        this.dbgrants.put(prev.toUpperCase(), columns);
        rs.close();
    }

    public static String comparePubuser() throws Exception {
        String str = "";
        connection = DatabaseConnFixture.getconnection();
        s = connection.createStatement();
        sqlstring = OR_SYNONYMS_QUERY;
        ResultSet rs = s.executeQuery(sqlstring);
        while (rs.next()) {
            str = rs.getString("synonym_name");
        }
        rs.close();
        if ("PUBUSER".equals(str)) {
            return "Pass";
        }
        return str;
    }

    public static String validateNextkey() throws Exception {
        String nextkeyerrors = "";
        int max = 0;
        int failures = 0;
        SchemaTestFixture.setDbTarget();
        s = connection.createStatement();
        String stmtstr = "select count(*) from user_tables where lower(table_name)=?";
        ResultSet rs = null;
        if (dbtarget == "OR") {
            rs = s.executeQuery(OR_NEXTKEYS_QUERY);
        } else {
            throw new SQLException("Invalid database target: " + dbtarget);
        }
        while (rs.next()) {
            String tab_name = rs.getString(1);
            String col_name = rs.getString(2);
            int key_seq_num = rs.getInt(4);
            int cnt = 0;
            max = 0;
            PreparedStatement s1 = connection.prepareStatement(stmtstr);
            s1.setString(1, tab_name);
            ResultSet rs1 = s1.executeQuery();
            while (rs1.next()) {
                cnt = rs1.getInt(1);
            }
            rs1.close();
            if (cnt <= 0 || "querylib".equals(tab_name)) continue;
            String stmtstr1 = "Select max(" + col_name + ") from " + tab_name;
            PreparedStatement s2 = connection.prepareStatement(stmtstr1);
            ResultSet rs2 = s2.executeQuery();
            while (rs2.next()) {
                max = rs2.getInt(1);
            }
            rs2.close();
            if (max <= key_seq_num) continue;
            nextkeyerrors = failures == 0 ? "NEXTKEY VALUES INCORRECT FOR:" + tab_name : nextkeyerrors + "," + tab_name;
            ++failures;
        }
        rs.close();
        if (failures > 0) {
            return nextkeyerrors;
        }
        return "Pass";
    }

    public static void getColumns() throws Exception {
        String prev = "";
        String curr = "";
        ArrayList<String> columns = null;
        dbcolumns.clear();
        dbobject = "";
        myObjects.clear();
        SchemaTestFixture.setDbTarget();
        s = connection.createStatement();
        if (dbtarget == "OR") {
            sqlstring = "select table_name,column_name from user_tab_columns order by table_name";
        } else if (dbtarget == "SS") {
            sqlstring = "select table_name,column_name from information_schema.columns where table_schema='" + username + "' order by table_name";
        }
        ResultSet rs = s.executeQuery(sqlstring);
        while (rs.next()) {
            curr = rs.getString("table_name");
            if ("".equals(prev)) {
                prev = curr;
                columns = new ArrayList<String>();
            }
            if (columns != null && prev.equals(curr)) {
                columns.add(rs.getString("column_name").toUpperCase());
                continue;
            }
            dbcolumns.put(prev.toUpperCase(), columns);
            columns = new ArrayList();
            columns.add(rs.getString("column_name").toUpperCase());
            prev = curr;
        }
        dbcolumns.put(prev.toUpperCase(), columns);
        rs.close();
    }

    public static String compareVersion() throws Exception {
        String versionstr = "";
        s = connection.createStatement();
        sqlstring = "select database_version from prefer";
        ResultSet rs = s.executeQuery(sqlstring);
        while (rs.next()) {
            versionstr = rs.getString("database_version");
        }
        rs.close();
        ListIterator<String> iter = li.listIterator();
        dbliobject = "";
        while (iter.hasNext()) {
            dbliobject = iter.next().toString();
        }
        if (versionstr.equals(dbliobject)) {
            return "Pass";
        }
        return "database version:" + versionstr + "schemafile version:" + dbliobject;
    }

    public static String verifyJobSvcIsEmpty() throws Exception {
        int cnt = 0;
        s = connection.createStatement();
        ResultSet rs = null;
        rs = s.executeQuery("Select count(1) from jobsvc");
        while (rs.next()) {
            cnt = rs.getInt(1);
        }
        rs.close();
        if (cnt == 0) {
            return "Pass";
        }
        return "JobService Table is not Empty";
    }

    public static String verifyLicense() throws Exception {
        int loblength = 0;
        SchemaTestFixture.setDbTarget();
        s = connection.createStatement();
        ResultSet rs = null;
        if (dbtarget == "OR") {
            rs = s.executeQuery(OR_LICENSE_QUERY);
        } else if (dbtarget == "SS") {
            rs = s.executeQuery(SS_LICENSE_QUERY);
        } else {
            throw new SQLException("Invalid database target: " + dbtarget);
        }
        while (rs.next()) {
            loblength = rs.getInt(1);
        }
        rs.close();
        if (loblength == 0) {
            return "Pass";
        }
        return "DATABASE is loaded with some LICENSE";
    }

    public static String compareResult() throws Exception {
        SchemaTestFixture.getObjects();
        return SchemaTestFixture.getResult();
    }

    public static String comparessIndexes() throws Exception {
        SchemaTestFixture.getssIndexes();
        return SchemaTestFixture.getResult();
    }

    public static String comparessTriggers() throws Exception {
        SchemaTestFixture.getssTriggers();
        return SchemaTestFixture.getResult();
    }

    public static String comparessConstraints() throws Exception {
        SchemaTestFixture.getssConstraints();
        return SchemaTestFixture.getResult();
    }

    public static String compareorViews() throws Exception {
        SchemaTestFixture.getorViews();
        return SchemaTestFixture.getResult();
    }

    public static String comparessViews() throws Exception {
        SchemaTestFixture.getssViews();
        return SchemaTestFixture.getResult();
    }

    public static String compareorConstraints() throws Exception {
        SchemaTestFixture.getorConstraints();
        return SchemaTestFixture.getResult();
    }

    public static String compareorProcedures() throws Exception {
        SchemaTestFixture.getorProcedures();
        return SchemaTestFixture.getResult();
    }

    public static String comparessProcedures() throws Exception {
        SchemaTestFixture.getssProcedures();
        return SchemaTestFixture.getResult();
    }

    public static String compareorColumns() throws Exception {
        SchemaTestFixture.getColumns();
        return SchemaTestFixture.compareColumns();
    }

    public static String comparessColumns() throws Exception {
        SchemaTestFixture.getColumns();
        return SchemaTestFixture.compareColumns();
    }

    public String compareorGrants() throws Exception {
        this.getGrants();
        return this.compareGrants();
    }

    public String comparessGrants() throws Exception {
        this.getGrants();
        return this.compareGrants();
    }

    public static String compareColumns() {
        Set<String> hashMapSet1 = tabcolumns.keySet();
        Set<String> hashMapSet2 = dbcolumns.keySet();
        HashMap<String, List<String>> diffcolumns = new HashMap<String, List<String>>();
        Iterator<String> iter = hashMapSet1.iterator();
        dbliobject = "";
        String table = "";
        while (iter.hasNext()) {
            table = iter.next();
            List<String> colList1 = null;
            List<String> colList2 = null;
            if (!hashMapSet2.contains(table)) continue;
            colList1 = tabcolumns.get(table);
            colList2 = dbcolumns.get(table);
            if (colList2.containsAll(colList1)) continue;
            colList1.removeAll(colList2);
            diffcolumns.put(table, new ArrayList<String>(colList1));
        }
        if (diffcolumns.isEmpty()) {
            hashMapSet1 = null;
            hashMapSet2 = null;
            return "Pass";
        }
        hashMapSet1 = null;
        hashMapSet2 = null;
        return SchemaTestFixture.printTabColumns(diffcolumns, "Columns");
    }

    public String compareGrants() {
        Set<String> hashMapSet1 = this.tabgrants.keySet();
        Set<String> hashMapSet2 = this.dbgrants.keySet();
        List<String> colList1 = null;
        List<String> colList2 = null;
        HashMap<String, List<String>> diffgrants = new HashMap<String, List<String>>();
        Iterator<String> iter = hashMapSet1.iterator();
        dbliobject = "";
        String table = "";
        while (iter.hasNext()) {
            table = iter.next();
            if (!hashMapSet2.contains(table.toUpperCase())) continue;
            if (this.tabgrants.containsKey(table)) {
                colList1 = this.tabgrants.get(table);
            }
            colList2 = this.dbgrants.get(table.toUpperCase());
            if (colList1 != null) {
                if (!colList2.containsAll(colList1)) {
                    colList1.removeAll(colList2);
                    diffgrants.put(table, new ArrayList<String>(colList1));
                }
                colList1.clear();
            }
            colList2.clear();
        }
        if (diffgrants.isEmpty()) {
            hashMapSet1 = null;
            hashMapSet2 = null;
            return "Pass";
        }
        hashMapSet1 = null;
        hashMapSet2 = null;
        return SchemaTestFixture.printTabColumns(diffgrants, "Grants");
    }

    public static String getResult() {
        if (myObjects.containsAll(li)) {
            return "Yes";
        }
        li.removeAll(myObjects);
        SchemaTestFixture.listtostr();
        return "Missing Objects in database:" + dbliobject;
    }

    public void setBatchfile(String batchfile) {
        this.m_batchfile = batchfile;
    }

    public void setDelay(long delay) throws Exception {
        this.m_delay = delay;
        Thread.sleep(this.m_delay);
    }

    static {
        names = new String[10];
        myObjects = new ArrayList<String>();
        tabcolumns = new HashMap();
        dbcolumns = new HashMap();
    }
}

