/*
 * Decompiled with CFR 0.152.
 */
package fixtures.util;

import com.primavera.database.common.ServerType;
import fit.ActionFixture;
import fixtures.util.DatabaseFixtureProperties;
import java.sql.Connection;

public class DatabaseSetup
extends ActionFixture {
    private static final String SUCCESS = "OK";
    public static final String PROPNAME_PRIMARY_ORACLE_URL = "PRIMARY_ORACLE_URL";
    public static final String PROPNAME_PRIMARY_SQLSERVER_URL = "PRIMARY_SQLSERVER_URL";
    public static final String PROPNAME_SECONDARY_ORACLE_URL = "PRIMARY_SECONDARY_URL";
    public static final String PROPNAME_SECONDARY_SQLSERVER_URL = "PRIMARY_SECONDARY_URL";
    public static final String PROPNAME_TERTIARY_ORACLE_URL = "PRIMARY_TERTIARY_URL";
    public static final String PROPNAME_TERTIARY_SQLSERVER_URL = "PRIMARY_TERTIARY_URL";
    public static Connection m_current_db_connection;
    public static String current_connection_prop;
    public String current_key;

    public String runCreate() {
        return SUCCESS;
    }

    public boolean connectOK() {
        return true;
    }

    private static String nvl(String s) {
        if (s == null) {
            return new String();
        }
        return s;
    }

    public static String getProperty(String name) {
        return DatabaseSetup.nvl(DatabaseFixtureProperties.properties.get(name.toUpperCase()));
    }

    public String getProperty() {
        return DatabaseSetup.getProperty(this.current_key);
    }

    public void setCurrentKey(String k) {
        this.current_key = k;
    }

    private String extractKey(String s) {
        return s.substring(0, s.indexOf("="));
    }

    private String extractVal(String s) {
        return s.substring(s.indexOf("=") + 1, s.length());
    }

    public void setProperty(String prop) throws Exception {
        if (prop.indexOf("=") <= 0) {
            throw new Exception("Property must have '=' in string (" + prop + ")");
        }
        String key = this.extractKey(prop);
        String val = this.extractVal(prop);
        if (key.length() == 0 || val.length() == 0) {
            throw new Exception("Key and value must be provided (" + prop + ")");
        }
        DatabaseFixtureProperties.properties.put(key.toUpperCase(), val);
    }

    public static void setCurrentConnectionProp(String name) {
        current_connection_prop = name;
    }

    private static ServerType serverTypeFromPropName(String name) {
        if (name.indexOf("ORACLE") > 0) {
            return ServerType.ORACLE;
        }
        if (name.indexOf("SYBASE") > 0) {
            return ServerType.SYBASE;
        }
        return ServerType.SQLSERVER;
    }

    public static void connect() throws Exception {
        String connprop = current_connection_prop;
        if (connprop == null || connprop.length() == 0) {
            throw new Exception("Connection property must be valid");
        }
        String url = DatabaseSetup.getProperty(connprop);
        ServerType st = DatabaseSetup.serverTypeFromPropName(connprop);
    }

    public static Connection getConnection() {
        return m_current_db_connection;
    }

    static {
        current_connection_prop = PROPNAME_PRIMARY_ORACLE_URL;
    }
}

