/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.common.util;

import com.primavera.common.JVMParam;
import com.primavera.common.StrUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLUtil {
    public static final int ARRAY_SIZE = 2048;
    public static final NodeValueParser<String> STRING_VALUE_PARSER = new StringNodeValueParser();
    public static final String DISALLOW_DOCTYPE_DECL = "http://apache.org/xml/features/disallow-doctype-decl";

    public static SAXParser newClientSAXParserNoDoctype() throws SAXException, ParserConfigurationException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        if (!"true".equalsIgnoreCase(JVMParam.P6_XML_ALLOWDOCTYPEDECLS.getValue())) {
            sAXParserFactory.setFeature(DISALLOW_DOCTYPE_DECL, true);
        }
        return sAXParserFactory.newSAXParser();
    }

    public static DocumentBuilder newClientDocumentBuilderNoDoctype() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        if (!"true".equalsIgnoreCase(JVMParam.P6_XML_ALLOWDOCTYPEDECLS.getValue())) {
            documentBuilderFactory.setFeature(DISALLOW_DOCTYPE_DECL, true);
        }
        return documentBuilderFactory.newDocumentBuilder();
    }

    public static DocumentBuilder newClientDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        return documentBuilderFactory.newDocumentBuilder();
    }

    public static SAXParser newClientSAXParser() throws SAXException, ParserConfigurationException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        return sAXParserFactory.newSAXParser();
    }

    public static Document documentFromString(String string) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder documentBuilder = XMLUtil.newClientDocumentBuilder();
        return documentBuilder.parse(new InputSource(new StringReader(string)));
    }

    public static Document documentFromStream(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder documentBuilder = XMLUtil.newClientDocumentBuilder();
        return documentBuilder.parse(new InputSource(new InputStreamReader(inputStream)));
    }

    public static Document documentFromInputSource(InputSource inputSource) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder documentBuilder = XMLUtil.newClientDocumentBuilder();
        return documentBuilder.parse(inputSource);
    }

    public static <T> T getNodeValue(Node node, NodeValueParser<T> nodeValueParser) {
        return nodeValueParser.parse(node != null ? node.getTextContent() : null);
    }

    public static String removeUnparseableSpecialChars(String string) {
        return string.replaceAll("&#(?:[1-8]|[0][1-8]|[1][1,2,4-9]|[2][0-9]|3[01]);", "");
    }

    public static String[] getChildNodeTextFromNodeNames(NodeList nodeList, String ... stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < nodeList.getLength() && n2 > 0; ++i2) {
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                if (stringArray2[i3] != null || !stringArray[i3].equals(nodeList.item(i2).getNodeName())) continue;
                stringArray2[i3] = nodeList.item(i2).getTextContent();
                --n2;
            }
        }
        return stringArray2;
    }

    public static Node[] getChildNodesFromNodeNames(NodeList nodeList, String ... stringArray) {
        Node[] nodeArray = new Node[stringArray.length];
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < nodeList.getLength() && n2 > 0; ++i2) {
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                if (nodeArray[i3] != null || !stringArray[i3].equals(nodeList.item(i2).getNodeName())) continue;
                nodeArray[i3] = nodeList.item(i2);
                --n2;
            }
        }
        return nodeArray;
    }

    public static class BooleanNodeValueParser
    implements NodeValueParser<Boolean> {
        private final Boolean a;

        public BooleanNodeValueParser(Boolean bl) {
            this.a = bl;
        }

        @Override
        public Boolean parse(String string) {
            if (StrUtil.isEmpty(string)) {
                return this.a;
            }
            return Boolean.valueOf(string);
        }
    }

    public static class StringNodeValueParser
    implements NodeValueParser<String> {
        @Override
        public String parse(String string) {
            return string;
        }
    }

    public static class IntegerNodeValueParser
    extends NumberNodeValueParser<Integer> {
        public IntegerNodeValueParser(Integer n2) {
            super(n2);
        }

        @Override
        public Integer parseTemplate(String string) {
            return Integer.valueOf(string);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static abstract class NumberNodeValueParser<T extends Number>
    implements NodeValueParser<T> {
        protected final T if;

        public NumberNodeValueParser(T t2) {
            this.if = t2;
        }

        @Override
        public T parse(String string) {
            if (StrUtil.isEmpty(string)) {
                return this.if;
            }
            try {
                return this.parseTemplate(string);
            }
            catch (NumberFormatException numberFormatException) {
                return this.if;
            }
        }

        protected abstract T parseTemplate(String var1);
    }

    public static class DoubleNodeValueParser
    extends NumberNodeValueParser<Double> {
        public DoubleNodeValueParser(Double d2) {
            super(d2);
        }

        @Override
        public Double parseTemplate(String string) {
            return Double.valueOf(string);
        }
    }

    public static interface NodeValueParser<T> {
        public T parse(String var1);
    }
}

