/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.common.util;

import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ThreadDumpBean {
    private boolean if;
    private long a = System.currentTimeMillis();
    private static final DateFormat do = new SimpleDateFormat("MM.dd.yyyy HH:mm:ss Z");

    public List<String[]> getAllThreadStacks() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        try {
            ThreadInfo[] threadInfoArray;
            this.a = System.currentTimeMillis();
            ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
            for (ThreadInfo threadInfo : threadInfoArray = threadMXBean.dumpAllThreads(true, true)) {
                arrayList.add(this.a(threadInfo));
            }
        }
        catch (Exception exception) {
            this.if = true;
            arrayList.add(new String[]{"ERROR: " + exception.getMessage()});
        }
        return arrayList;
    }

    private String[] a(ThreadInfo threadInfo) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("\"%s\" #%d: %s", new Object[]{threadInfo.getThreadName(), threadInfo.getThreadId(), threadInfo.getThreadState()}));
        stringBuilder.append(threadInfo.getLockName() != null ? " on lock=" + threadInfo.getLockName() : (threadInfo.isSuspended() ? " (suspended)" : (threadInfo.isInNative() ? " (running in native)" : "")));
        if (threadInfo.getLockOwnerName() != null) {
            stringBuilder.append(" (owned by ").append(threadInfo.getLockOwnerName()).append(" #").append(threadInfo.getLockOwnerId()).append(")");
        }
        StackTraceElement[] stackTraceElementArray = threadInfo.getStackTrace();
        MonitorInfo[] monitorInfoArray = threadInfo.getLockedMonitors();
        String[] stringArray = new String[1 + stackTraceElementArray.length + monitorInfoArray.length];
        int n2 = 0;
        stringArray[n2++] = stringBuilder.toString();
        for (int i2 = 0; i2 < stackTraceElementArray.length; ++i2) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i2];
            stringArray[n2++] = "    at " + stackTraceElement.toString();
            for (MonitorInfo monitorInfo : monitorInfoArray) {
                if (monitorInfo.getLockedStackDepth() != i2) continue;
                stringArray[n2++] = "     - locked " + monitorInfo.toString();
            }
        }
        return stringArray;
    }

    public boolean getSecurityFailure() {
        return this.if;
    }

    public String getTimestamp() {
        return do.format(this.a);
    }

    public String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return "<UnknownHostname>";
        }
    }
}

