/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.common.util;

import java.io.StringReader;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.apache.commons.text.StringEscapeUtils;

public class HTMLUtils {
    public static String getRawTextFromHTMLString(String string) {
        try {
            if (string == null) {
                return "";
            }
            if (string.indexOf(60) >= 0 && string.indexOf(62) >= 0) {
                string = HTMLUtils.removeStyleTag(string);
                return HTMLUtils.a(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public static String removeStyleTag(String string) {
        int n2 = string.indexOf("<style");
        String string2 = "</style>";
        int n3 = string.indexOf(string2);
        if (n2 > -1 && n3 > -1) {
            String string3 = string.substring(0, n2);
            String string4 = string.substring(n3 + string2.length());
            string = string3 + string4;
        }
        return string;
    }

    public static String escapeHtml(String string) {
        return StringEscapeUtils.escapeHtml4((String)string);
    }

    public static String unEscapeHtml(String string) {
        return StringEscapeUtils.unescapeHtml4((String)string);
    }

    public static String getRawTextFromNotebookHTMLString(String string) {
        try {
            if (string == null) {
                return "";
            }
            if (string.indexOf(60) >= 0 && string.indexOf(62) >= 0) {
                string = HTMLUtils.removeStyleTagOrAttribute(string);
                return HTMLUtils.a(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public static String removeStyleTagOrAttribute(String string) {
        String string2 = "style=";
        String string3 = ">";
        int n2 = 0;
        boolean bl = true;
        while ((string.contains("<style") || string.contains(string2)) && bl) {
            bl = false;
            int n3 = string.indexOf("<style");
            String string4 = "</style>";
            int n4 = string.indexOf(string4);
            n2 = string4.length();
            if ((string.contains("<h") || string.toLowerCase().contains("<span")) && n3 < 0 && n4 < 0) {
                n3 = string.indexOf(string2);
                n4 = string.indexOf(string3, n3);
                n2 = 0;
            }
            if (n3 <= -1 || n4 <= -1) continue;
            String string5 = string.substring(0, n3);
            String string6 = string.substring(n4 + n2);
            string = string5 + string6;
            bl = true;
        }
        return string;
    }

    private static String a(String string) {
        try {
            HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
            HTMLDocument hTMLDocument = new HTMLDocument();
            hTMLDocument.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
            StringReader stringReader = new StringReader(string);
            hTMLEditorKit.read(stringReader, (Document)hTMLDocument, 0);
            String string2 = hTMLDocument.getText(0, hTMLDocument.getLength());
            if (string2 != null) {
                string2 = string2.trim();
                while (string2.length() > 0 && Character.isSpaceChar(string2.charAt(0))) {
                    string2 = string2.substring(1).trim();
                }
                String string3 = "!?xml:namespace prefix = o ns = \"urn:schemas-microsoft-com:office:office\" />";
                int n2 = string2.indexOf(string3);
                if (n2 > -1) {
                    string2 = string2.substring(0, n2) + string2.substring(n2 + string3.length());
                }
                string2 = string2.replace('\u00a0', ' ');
            }
            return string2;
        }
        catch (Exception exception) {
            return string;
        }
    }
}

