/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.common.util;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class CollectionsUtil {
    private CollectionsUtil() {
    }

    public static <T> void forEach(T[] TArray, ItemClosure<T> itemClosure) {
        CollectionsUtil.forEach(Arrays.asList(TArray), itemClosure);
    }

    public static <T> void forEach(Collection<T> collection, ItemClosure<T> itemClosure) {
        block1: {
            T t2;
            boolean bl;
            if (collection == null) break block1;
            Iterator<T> iterator = collection.iterator();
            while (iterator.hasNext() && !(bl = !itemClosure.onItem(t2 = iterator.next()))) {
            }
        }
    }

    public static <T, K> T ensureFromMap(Map<K, T> map, K k2, T t2) {
        Object object = map.get(k2);
        if (object == null) {
            try {
                Method method = t2.getClass().getMethod("clone", new Class[0]);
                object = method != null ? method.invoke(t2, new Object[0]) : t2;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                object = t2;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (object != null) {
                map.put(k2, object);
            }
        }
        return object;
    }

    public static <T> Set<T> union(Collection<T> ... collectionArray) {
        LinkedHashSet<T> linkedHashSet = new LinkedHashSet<T>();
        for (Collection<T> collection : collectionArray) {
            for (T t2 : collection) {
                linkedHashSet.add(t2);
            }
        }
        return linkedHashSet;
    }

    public static <T> Set<T> intersection(Collection<T> collection, Collection<T> collection2) {
        HashSet<T> hashSet = new HashSet<T>(collection);
        hashSet.retainAll(collection2);
        return hashSet;
    }

    public static int[] toPrimitiveIntArray(Collection<Integer> collection) {
        if (collection == null) {
            return null;
        }
        if (collection.size() == 0) {
            return new int[0];
        }
        int[] nArray = new int[collection.size()];
        int n2 = 0;
        for (Integer n3 : collection) {
            nArray[n2++] = n3;
        }
        return nArray;
    }

    public static <K, V> Map<K, V> initMap(Map<K, V> map, Object ... objectArray) {
        for (int i2 = 0; i2 < objectArray.length; i2 += 2) {
            map.put(objectArray[i2], objectArray[i2 + 1]);
        }
        return map;
    }

    public static <K> Set<K> initSet(Set<K> set, K ... KArray) {
        for (K k2 : KArray) {
            set.add(k2);
        }
        return set;
    }

    public static class UnmodifiableMapBuilder<T, K> {
        private final Map<T, K> a = new HashMap<T, K>();

        public UnmodifiableMapBuilder<T, K> put(T t2, K k2) {
            this.a.put(t2, k2);
            return this;
        }

        public Map<T, K> build() {
            return Collections.unmodifiableMap(this.a);
        }
    }

    public static interface ItemClosure<T> {
        public boolean onItem(T var1);
    }
}

