/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.common.formulaparser;

import com.primavera.common.formulaparser.Formula;
import com.primavera.common.formulaparser.ParseException;
import com.primavera.common.formulaparser.TestDataProvider;
import com.primavera.common.formulaparser.TestTranslator;
import com.primavera.common.formulaparser.TokenMgrError;
import java.util.GregorianCalendar;
import javax.swing.JOptionPane;

public class GrammarTest2 {
    static String[] a = new String[]{"Evaluate", "Parse", "Validation", "Translate", "GetVarList"};

    public static void main(String[] stringArray) throws ParseException {
        TestDataProvider testDataProvider = new TestDataProvider();
        testDataProvider.addObject("var1", 10.0);
        testDataProvider.addObject("var2", 20.0);
        testDataProvider.addObject("var3", 30.0);
        testDataProvider.addObject("var4", 40.0);
        testDataProvider.addObject("CurrentBudget", 100.0);
        testDataProvider.addObject("CurrentVariance", 25.0);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(2005, 9, 17);
        testDataProvider.addObject("ActualFinish", gregorianCalendar.getTime());
        gregorianCalendar = (GregorianCalendar)gregorianCalendar.clone();
        gregorianCalendar.add(5, -7);
        testDataProvider.addObject("ActualStart", gregorianCalendar.getTime());
        testDataProvider.addObject("TotalFunding", 300.0);
        testDataProvider.addObject("ActualLaborCost", 40.0);
        testDataProvider.addObject("ActualTotalCost", 40.0);
        testDataProvider.addObject("RemainingTotalCost", 100.99);
        testDataProvider.addObject("ActualCost", 400.0);
        testDataProvider.addObject("PlannedValueCost", 310.0);
        testDataProvider.addObject("Message", "bla bla bla random message");
        testDataProvider.addObject("AktuellesBudget", 3001.0);
        testDataProvider.addObject("\u674e", 301.0);
        testDataProvider.addObject("h", 4003, null);
        testDataProvider.addObject("d", 4003, 24.0);
        testDataProvider.addObject("w", 4003, 40.0);
        testDataProvider.addObject("m", 4003, 172.0);
        testDataProvider.addObject("y", 4003, 2000.0);
        System.out.println("Vars List:");
        testDataProvider.display();
        TestTranslator testTranslator = new TestTranslator();
        testTranslator.addVariable("AktuellesBudget", "CurrentBudget");
        testTranslator.addVariable("AktuelleAbweichung", "CurrentVariance");
        testTranslator.addVariable("IstEnde", "ActualFinish");
        testTranslator.addVariable("IstStart", "ActualStart");
        testTranslator.addVariable("Finanzierung", "TotalFunding");
        testTranslator.addVariable("Abweichung BP1 Arbeitskosten", "ActualLaborCost");
        testTranslator.addVariable("IstGesamtkosten", "ActualTotalCost");
        testTranslator.addVariable("VerbleibendeGesamtkosten", "RemainingTotalCost");
        testTranslator.addVariable("IstKosten", "ActualCost");
        testTranslator.addVariable("\u8d39\u7528", "ActualCost");
        testTranslator.addVariable("GeplanterWert", "PlannedValueCost");
        testTranslator.addVariable("Anzeige", "Message");
        testTranslator.addVariable("Tag", "d");
        testTranslator.addVariable("Stunde", "h");
        testTranslator.addVariable("Woche", "w");
        testTranslator.addVariable("Monat", "m");
        testTranslator.addVariable("Jahr", "y");
        System.out.println("Vars&Alias List:");
        testTranslator.display();
        String string = JOptionPane.showInputDialog("Please input an Expression ");
        System.out.println("inputExp is " + string);
        if (string == null) {
            return;
        }
        Formula formula = new Formula(string);
        formula.setTranslator(testTranslator);
        formula.setDataProvider(testDataProvider);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        try {
            String string2 = (String)JOptionPane.showInputDialog(null, "Choose Options", "", 1, null, a, a[0]);
            if (string2 == null) {
                return;
            }
            String string3 = "";
            boolean bl = false;
            if ("Evaluate".equals(string2)) {
                string3 = formula.myevaluate().toString();
                bl = true;
            } else if ("Parse".equals(string2)) {
                formula.parse();
                bl = false;
            } else {
                if ("Translate".equals(string2)) {
                    string3 = formula.translate();
                    JOptionPane.showMessageDialog(null, "Translated Formula is:  " + string3, "Result", 1);
                    System.out.println("Translated Formula is:  " + string3);
                    return;
                }
                if ("Validation".equals(string2)) {
                    formula.validate();
                    bl = false;
                } else if ("GetVarList".equals(string2)) {
                    formula.getVarList();
                    bl = false;
                }
            }
            string3 = string3 + "\n A Valid Expression!\nVariable(s) Count: " + formula.getVarCount() + "\nVariable(s) List:\n" + formula.getVarListString(bl);
            JOptionPane.showMessageDialog(null, formula.inputFormula + "\n is " + string3, "Result", 1);
            System.out.println("Valid Expression!");
            System.out.println("\nVar Count: " + formula.getVarCount());
            System.out.println("\nVarsList:\n" + formula.getVarListString(bl));
            return;
        }
        catch (ParseException parseException) {
            System.err.println("InValid Expression: " + string);
            System.err.println("ParseException:");
            System.err.println(parseException.getMessage());
            if (formula.errorNode == null) {
                n2 = parseException.currentToken.next.beginLine;
                n3 = parseException.currentToken.next.beginColumn;
                n4 = parseException.currentToken.next.endLine;
                n5 = parseException.currentToken.next.endColumn;
            } else {
                n2 = formula.errorNode.getBeginLine();
                n3 = formula.errorNode.getBeginColumn();
                n4 = formula.errorNode.getEndLine();
                n5 = formula.errorNode.getEndColumn();
            }
            n6 = formula.lineColumnToOffset(n2, n3);
            n7 = formula.lineColumnToOffset(n4, n5);
            String string4 = "Input Formula: " + formula.inputFormula + "\n";
            string4 = string4 + "errorBeginLine : " + n2 + "\n";
            string4 = string4 + "errorBeginColumn : " + n3 + "\n";
            string4 = string4 + "errorEndLine : " + n4 + "\n";
            string4 = string4 + "errorEndColumn : " + n5 + "\n";
            string4 = string4 + "errorBeginAt : " + n6 + "\n";
            string4 = string4 + "errorEndAt: " + n7 + "\n";
            JOptionPane.showMessageDialog(null, string4, "Errors", 0);
            parseException.printStackTrace();
        }
        catch (TokenMgrError tokenMgrError) {
            System.err.println("Error:");
            String string5 = tokenMgrError.getMessage();
            System.err.println(string5);
            String[] stringArray2 = string5.split("[\\s|,|.]");
            for (int i2 = 0; i2 < stringArray2.length; ++i2) {
                if ("line".equals(stringArray2[i2])) {
                    n4 = n2 = Integer.parseInt(stringArray2[i2 + 1]);
                }
                if (!"column".equals(stringArray2[i2])) continue;
                n3 = Integer.parseInt(stringArray2[i2 + 1]);
                if (string5.indexOf("Encountered: <EOF>") != -1) {
                    // empty if block
                }
                n5 = --n3;
            }
            n6 = formula.lineColumnToOffset(n2, n3);
            n7 = formula.lineColumnToOffset(n4, n5);
            string5 = "Input Formula: " + formula.inputFormula + "\n";
            string5 = string5 + "errorBeginLine : " + n2 + "\n";
            string5 = string5 + "errorBeginColumn : " + n3 + "\n";
            string5 = string5 + "errorEndLine : " + n4 + "\n";
            string5 = string5 + "errorEndColumn : " + n5 + "\n";
            string5 = string5 + "errorBeginAt : " + n6 + "\n";
            string5 = string5 + "errorEndAt: " + n7 + "\n";
            JOptionPane.showMessageDialog(null, string5, "Errors", 0);
            tokenMgrError.printStackTrace();
        }
    }
}

