/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.common.db;

import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DatabaseURLParser {
    public static final String ORACLE_DRIVER = "oracle.jdbc.OracleDriver";
    public static final String SQLSERVER_DRIVER = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    private static final String byte = "com.mockrunner.mock.jdbc.MockDriver";
    private static final Pattern a = Pattern.compile("jdbc:oracle:thin:@\\(DESCRIPTION=\\(LOAD_BALANCE=on\\)\\(ADDRESS=\\(PROTOCOL=TCP\\)\\(HOST=(.*)\\)\\s*\\(PORT=(.*)\\)\\)\\(CONNECT_DATA=\\(SERVICE_NAME=(.*)\\)\\)\\)", 2);
    private static final Pattern else = Pattern.compile("jdbc:oracle:((?:thin)|(?:oci)):@\\(DESCRIPTION=(?:\\(SDU=[0-9]*\\))?(?:\\(ADDRESS_LIST=)?(?:\\(ADDRESS=\\(PROTOCOL=([^\\)]*)\\)\\(HOST=([^\\)]*)\\)\\(PORT=([0-9]*)\\)\\))+(?:\\))?\\(CONNECT_DATA=(?:\\(SERVER=[^\\)]*\\))?\\((?:(?:SID)|(?:SERVICE_NAME))=([^\\)]*)\\)(?:\\(SERVER=[^\\)]*\\))?\\)\\)", 2);
    private static final Pattern if = Pattern.compile("jdbc:oracle:((?:thin)|(?:oci)):@.*HOST=([^\\)]*).*PORT=([0-9]*).*");
    private static final Pattern try = Pattern.compile("jdbc:oracle:thin:@([^:]*):([^:]*)(/|:)(.*)", 2);
    private static final Pattern new = Pattern.compile("jdbc:oracle:thin:@([^:]*)\\?TNS_ADMIN=(.*)", 2);
    private static final Pattern b = Pattern.compile("jdbc:oracle:oci:@([^:]*):([^:]*)(/|:)(.*)", 2);
    private static final Pattern goto = Pattern.compile("jdbc:sqlserver://([^:]*):([0-9]*);database=([^;]*)(.*)", 2);
    private static final Pattern for = Pattern.compile("jdbc:mock://([^:]*):([0-9]*)/database=(.*)", 2);
    private DriverType do;
    private boolean int;
    private boolean char;
    private String long;
    private int case;
    private String c;
    private boolean void;

    public DatabaseURLParser(String string) throws SQLException {
        string = string.replaceAll("\\s", "");
        Matcher matcher = else.matcher(string);
        if (matcher.matches() && matcher.groupCount() == 5) {
            this.do = DriverType.ORACLE;
            this.int = !"oci".equalsIgnoreCase(matcher.group(1));
            this.char = "tcps".equalsIgnoreCase(matcher.group(2));
            this.long = matcher.group(3);
            this.case = Integer.parseInt(matcher.group(4));
            this.c = matcher.group(5);
            this.void = false;
            return;
        }
        matcher = try.matcher(string);
        if (matcher.matches() && matcher.groupCount() == 4) {
            this.do = DriverType.ORACLE;
            this.int = true;
            this.char = false;
            this.long = matcher.group(1);
            this.case = Integer.parseInt(matcher.group(2));
            this.void = "/".equals(matcher.group(3));
            this.c = matcher.group(4);
            return;
        }
        matcher = new.matcher(string);
        if (matcher.matches() && matcher.groupCount() == 2) {
            this.do = DriverType.ORACLE;
            this.int = true;
            this.char = false;
            this.long = matcher.group(2);
            this.c = matcher.group(1);
            return;
        }
        matcher = a.matcher(string);
        if (matcher.matches() && matcher.groupCount() == 3) {
            this.do = DriverType.ORACLE;
            this.int = true;
            this.char = false;
            this.long = matcher.group(1);
            this.case = Integer.parseInt(matcher.group(2));
            this.c = matcher.group(3);
            this.void = true;
            return;
        }
        matcher = b.matcher(string);
        if (matcher.matches() && matcher.groupCount() == 4) {
            this.do = DriverType.ORACLE;
            this.int = false;
            this.char = false;
            this.long = matcher.group(1);
            this.case = Integer.parseInt(matcher.group(2));
            this.void = "/".equals(matcher.group(3));
            this.c = matcher.group(4);
            return;
        }
        matcher = goto.matcher(string);
        if (matcher.matches() && matcher.groupCount() >= 3) {
            this.do = DriverType.SQLSERVER;
            this.int = true;
            this.char = false;
            this.long = matcher.group(1);
            this.case = Integer.parseInt(matcher.group(2));
            this.c = matcher.group(3);
            this.void = false;
            if (matcher.groupCount() == 4) {
                String string2 = matcher.group(4);
                this.char = string2.contains("encrypt=true");
            }
            return;
        }
        matcher = for.matcher(string);
        if (matcher.matches() && matcher.groupCount() == 3) {
            this.do = DriverType.MOCK;
            this.int = false;
            this.char = false;
            this.long = matcher.group(1);
            this.case = Integer.parseInt(matcher.group(2));
            this.c = matcher.group(3);
            this.void = false;
            return;
        }
        matcher = if.matcher(string);
        if (matcher.matches() && matcher.groupCount() == 3) {
            this.do = DriverType.ORACLE;
            this.int = !"oci".equalsIgnoreCase(matcher.group(1));
            this.char = false;
            this.long = matcher.group(2);
            this.case = Integer.parseInt(matcher.group(3));
            this.void = false;
            return;
        }
        this.do = DriverType.OTHER;
        this.int = false;
        this.char = false;
        this.long = null;
        this.case = 0;
        this.void = false;
    }

    public boolean isOracle() {
        return this.do == DriverType.ORACLE;
    }

    public boolean isThin() {
        return this.int;
    }

    public boolean isSSL() {
        return this.char;
    }

    public String getServer() {
        return this.long;
    }

    public int getPort() {
        return this.case;
    }

    public String getName() {
        return this.c;
    }

    public boolean isService() {
        return this.void;
    }

    public String getDriverName() {
        switch (this.do) {
            case ORACLE: {
                return ORACLE_DRIVER;
            }
            case SQLSERVER: {
                return SQLSERVER_DRIVER;
            }
            case MOCK: {
                return byte;
            }
            case OTHER: {
                return "";
            }
        }
        throw new IllegalStateException("Unable to determine driver name for type: " + (Object)((Object)this.do));
    }

    private static enum DriverType {
        ORACLE,
        SQLSERVER,
        MOCK,
        OTHER;

    }
}

