/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.common.cache;

import com.primavera.common.cache.PolicyEnforcer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class LRUPolicyEnforcer<K, V>
implements PolicyEnforcer<K, V> {
    private static final float d = 0.75f;
    private static final String g = System.getProperty("line.separator");
    private final Map<K, V> c;
    private final ReadWriteLock e = new ReentrantReadWriteLock();
    private int f;

    public LRUPolicyEnforcer(int n2) {
        this.f = n2;
        this.c = new LinkedHashMap<K, V>(this.f, 0.75f, true){
            private static final long if = 3541062748739431139L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> entry) {
                return this.size() > LRUPolicyEnforcer.this.f;
            }
        };
    }

    @Override
    public void setLimit(int n2) {
        this.f = n2;
        this.audit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K k2, V v2) {
        this.e.writeLock().lock();
        try {
            V v3 = this.c.put(k2, v2);
            return v3;
        }
        finally {
            this.e.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object object) {
        try {
            this.e.readLock().lock();
            if (this.c.containsKey(object)) {
                V v2;
                try {
                    this.e.readLock().unlock();
                    this.e.writeLock().lock();
                    v2 = this.c.get(object);
                    this.e.readLock().lock();
                    this.e.writeLock().unlock();
                }
                catch (Throwable throwable) {
                    this.e.readLock().lock();
                    this.e.writeLock().unlock();
                    throw throwable;
                }
                return v2;
            }
        }
        finally {
            this.e.readLock().unlock();
        }
        return null;
    }

    @Override
    public void clear() {
        this.e.writeLock().lock();
        try {
            this.c.clear();
        }
        finally {
            this.e.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object object) {
        try {
            this.e.readLock().lock();
            if (this.c.containsKey(object)) {
                V v2;
                this.e.readLock().unlock();
                this.e.writeLock().lock();
                try {
                    v2 = this.c.remove(object);
                    this.e.readLock().lock();
                    this.e.writeLock().unlock();
                }
                catch (Throwable throwable) {
                    this.e.readLock().lock();
                    this.e.writeLock().unlock();
                    throw throwable;
                }
                return v2;
            }
        }
        finally {
            this.e.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean audit() {
        this.e.readLock().lock();
        try {
            if (this.c.size() > this.f) {
                int n2;
                this.e.readLock().unlock();
                this.e.writeLock().lock();
                try {
                    n2 = this.c.size() - this.f;
                    if (n2 > 0) {
                        Iterator<K> iterator = this.c.keySet().iterator();
                        for (int i2 = 0; i2 < n2; i2 += 1) {
                            iterator.next();
                            iterator.remove();
                        }
                    }
                }
                finally {
                    this.e.readLock().lock();
                    this.e.writeLock().unlock();
                }
                n2 = 1;
                return n2 != 0;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.e.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Least Recently used Enforcer");
        stringBuilder.append(g);
        this.e.readLock().lock();
        try {
            stringBuilder.append("Number of elements in the cache = ");
            stringBuilder.append(this.c.size());
            stringBuilder.append(g);
            Set<Map.Entry<K, V>> set = this.c.entrySet();
            for (Map.Entry<K, V> entry : set) {
                stringBuilder.append(entry.getKey());
                stringBuilder.append('=');
                stringBuilder.append(entry.getValue());
            }
            String string = stringBuilder.toString();
            return string;
        }
        finally {
            this.e.readLock().unlock();
        }
    }
}

