/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.common;

import com.primavera.PhoenixException;
import com.primavera.common.CBSCode;
import com.primavera.common.unifier.client.UnifierParserUtility;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CBSCodesParserUtility {
    public static List<CBSCode> getUnifierCBSCodes(String string) throws Exception {
        Document document = UnifierParserUtility.getFileDocument((String)string);
        if (document == null) {
            return null;
        }
        String string2 = "/List_Wrapper/costcodes/costcode";
        NodeList nodeList = UnifierParserUtility.getNodes((Document)document, (String)string2);
        if (nodeList.getLength() == 0) {
            return null;
        }
        return CBSCodesParserUtility.a(nodeList);
    }

    private static List<CBSCode> a(NodeList nodeList) throws PhoenixException {
        ArrayList<CBSCode> arrayList = new ArrayList<CBSCode>();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            NodeList nodeList2;
            CBSCode cBSCode = new CBSCode();
            Node node = nodeList.item(i2);
            if (node == null || (nodeList2 = node.getChildNodes()) == null) continue;
            for (int i3 = 0; i3 < nodeList2.getLength(); ++i3) {
                Node node2 = nodeList2.item(i3);
                if (node2.getNodeName().equals("wbscode")) {
                    cBSCode.setCodeName(node2.getTextContent());
                    continue;
                }
                if (node2.getNodeName().equals("wbsitem")) {
                    cBSCode.setCodeDescription(node2.getTextContent());
                    continue;
                }
                if (node2.getNodeName().equals("costtype")) {
                    cBSCode.setCostType(node2.getTextContent());
                    continue;
                }
                if (node2.getNodeName().equals("status")) {
                    cBSCode.setStatus(node2.getTextContent());
                    continue;
                }
                if (node2.getNodeName().equals("wbscodeid")) {
                    cBSCode.setCodeId(Integer.parseInt(node2.getTextContent()));
                    continue;
                }
                if (node2.getNodeName().equals("parentid")) {
                    cBSCode.setParentId(Integer.parseInt(node2.getTextContent()));
                    continue;
                }
                if (node2.getNodeName().equals("indentlevel")) {
                    cBSCode.setIndentLevel(Integer.parseInt(node2.getTextContent()));
                    continue;
                }
                if (!node2.getNodeName().equals("orderid")) continue;
                cBSCode.setOrderId(Integer.parseInt(node2.getTextContent()));
            }
            arrayList.add(cBSCode);
        }
        return arrayList;
    }

    public static List<CBSCode> getRootNodes(List<CBSCode> list) throws PhoenixException {
        ArrayList<CBSCode> arrayList = new ArrayList<CBSCode>();
        for (CBSCode cBSCode : list) {
            if (!CBSCodesParserUtility.a(cBSCode.getParentId(), list)) continue;
            arrayList.add(cBSCode);
        }
        return arrayList;
    }

    public static int getCBSCodeId(String string, List<CBSCode> list) {
        for (CBSCode cBSCode : list) {
            if (!cBSCode.getCodeName().equals(string)) continue;
            return cBSCode.getCodeId();
        }
        return 0;
    }

    private static boolean a(int n2, List<CBSCode> list) {
        for (CBSCode cBSCode : list) {
            if (cBSCode.getCodeId() != n2) continue;
            return false;
        }
        return true;
    }

    public static boolean isLeafNode(int n2, List<CBSCode> list) {
        for (CBSCode cBSCode : list) {
            int n3 = cBSCode.getParentId();
            if (n3 != n2) continue;
            return false;
        }
        return true;
    }

    public static String getHierarchyPath(CBSCode cBSCode, List<CBSCode> list) {
        String string = cBSCode.getCodeName();
        CBSCode cBSCode2;
        while ((cBSCode2 = CBSCodesParserUtility.getParent(cBSCode, list)) != null) {
            string = cBSCode2.getCodeName() + "~~" + string;
            cBSCode = cBSCode2;
        }
        return string;
    }

    public static CBSCode getParent(CBSCode cBSCode, List<CBSCode> list) {
        for (CBSCode cBSCode2 : list) {
            if (cBSCode.getParentId() != cBSCode2.getCodeId()) continue;
            return cBSCode2;
        }
        return null;
    }
}

