/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.common;

import com.primavera.common.JVMParam;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ApplicationProperties {
    private static final String for = "/application.properties";
    private static ApplicationProperties do = null;
    private Properties a = null;
    private String int = null;
    private String new = null;
    private OracleCloudDeploymentType if = OracleCloudDeploymentType.NOCLOUD;
    private static Object try = new Object();

    protected ApplicationProperties() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApplicationProperties getInstance() {
        if (do != null) {
            return do;
        }
        Object object = try;
        synchronized (object) {
            if (do != null) {
                return do;
            }
            ApplicationProperties applicationProperties = new ApplicationProperties();
            try {
                applicationProperties.a();
                System.setProperty("APPLICATION_NAME", applicationProperties.getApplicationName());
                applicationProperties.if();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("ERROR initializing ApplicationProperties. Details: " + exception.toString());
            }
            do = applicationProperties;
        }
        return do;
    }

    private void a() throws Exception {
        if (this.a != null) {
            return;
        }
        InputStream inputStream = this.getClass().getResourceAsStream(for);
        if (inputStream == null) {
            return;
        }
        Properties properties = new Properties();
        properties.load(inputStream);
        this.a = properties;
    }

    private void if() {
        try {
            String string = JVMParam.CEGBU_CLOUD.getValue("").toLowerCase();
            if (string.equals("oci")) {
                this.if = OracleCloudDeploymentType.OCI;
            } else if (string.equals("gbucs")) {
                this.if = OracleCloudDeploymentType.GBUCS;
            } else if (string.equals("nocloud")) {
                this.if = OracleCloudDeploymentType.NOCLOUD;
            } else {
                String string2 = InetAddress.getLocalHost().getHostName().toLowerCase();
                if (string2.endsWith(".occloud")) {
                    this.if = OracleCloudDeploymentType.OCI;
                } else if (string2.endsWith(".oracleindustry.com")) {
                    this.if = OracleCloudDeploymentType.GBUCS;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public OracleCloudDeploymentType getCloudDeploymentType() {
        return this.if;
    }

    public String getProperty(String string) {
        if (this.a == null) {
            return "ApplicationPropertiesNotLoadedError";
        }
        return this.a.getProperty(string, "?");
    }

    public String getSystemUptime() {
        try {
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            long l2 = runtimeMXBean.getUptime();
            return this.a(l2);
        }
        catch (Exception exception) {
            return "Unknown";
        }
    }

    private String a(long l2) {
        long l3 = (l2 /= 1000L) / 86400L;
        long l4 = (l2 -= l3 * 86400L) / 3600L;
        long l5 = (l2 -= l4 * 60L * 60L) / 60L;
        long l6 = l2 - l5 * 60L;
        return String.format("%02dd %02dh %02dm %02ds", (int)l3, (int)l4, (int)l5, (int)l6);
    }

    public String getMBeanAttributeValues(String string) {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName objectName;
            if (string.startsWith("mbean:")) {
                string = string.substring(6);
            }
            if (!mBeanServer.isRegistered(objectName = new ObjectName(string))) {
                return "MBean '" + objectName.toString() + "' is not registered";
            }
            MBeanInfo mBeanInfo = mBeanServer.getMBeanInfo(objectName);
            MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanInfo.getAttributes();
            String[] stringArray = new String[mBeanAttributeInfoArray.length];
            int n2 = 0;
            for (MBeanAttributeInfo serializable : mBeanAttributeInfoArray) {
                stringArray[n2++] = serializable.getName();
            }
            AttributeList attributeList = mBeanServer.getAttributes(objectName, stringArray);
            Iterator iterator = attributeList.iterator();
            StringBuilder stringBuilder = new StringBuilder();
            while (iterator.hasNext()) {
                Attribute attribute = (Attribute)iterator.next();
                stringBuilder.append(String.format("%s=%s\n", attribute.getName(), attribute.getValue()));
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            return "An error occurred: " + exception.toString();
        }
    }

    public String getProcessId() {
        if (this.new == null) {
            try {
                String string = ManagementFactory.getRuntimeMXBean().getName();
                Matcher matcher = Pattern.compile("[0-9]+").matcher(string);
                if (matcher.find()) {
                    this.new = string.substring(matcher.start(), matcher.end());
                    return this.new;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.new = "";
        }
        return this.new;
    }

    public String getHostname() {
        if (this.int == null) {
            try {
                this.int = ManagementFactory.getRuntimeMXBean().getName();
                return this.int;
            }
            catch (Throwable throwable) {
                this.int = "??";
            }
        }
        return this.int;
    }

    public String getAppVersion() {
        return this.getProperty("version.id");
    }

    public String getChangeset() {
        return this.getProperty("build.changeset");
    }

    public String getBuildDate() {
        return this.getProperty("build.date");
    }

    public String getApplicationName() {
        return this.getProperty("application.name");
    }

    public void printProps() {
        System.out.println(this.getApplicationName() + ": " + this.getAppVersion());
        System.out.println("Changeset: " + this.getChangeset());
        System.out.println("Build Date: " + this.getBuildDate());
    }

    public static enum OracleCloudDeploymentType {
        NOCLOUD,
        OCI,
        GBUCS;

    }
}

